/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.test.json.AbstractJsonMarshalTester;
import org.springframework.boot.test.json.JsonContent;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

@Deprecated(since="4.0.0", forRemoval=true)
public class Jackson2Tester<T>
extends AbstractJsonMarshalTester<T> {
    private final ObjectMapper objectMapper;
    private @Nullable Class<?> view;

    protected Jackson2Tester(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null");
        this.objectMapper = objectMapper;
    }

    public Jackson2Tester(Class<?> resourceLoadClass, ResolvableType type, ObjectMapper objectMapper) {
        this(resourceLoadClass, type, objectMapper, null);
    }

    public Jackson2Tester(Class<?> resourceLoadClass, ResolvableType type, ObjectMapper objectMapper, @Nullable Class<?> view) {
        super(resourceLoadClass, type);
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null");
        this.objectMapper = objectMapper;
        this.view = view;
    }

    @Override
    protected JsonContent<T> getJsonContent(String json) {
        Configuration configuration = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider(this.objectMapper)).mappingProvider((MappingProvider)new JacksonMappingProvider(this.objectMapper)).build();
        Class<?> resourceLoadClass = this.getResourceLoadClass();
        Assert.state((resourceLoadClass != null ? 1 : 0) != 0, (String)"'resourceLoadClass' must not be null");
        return new JsonContent(resourceLoadClass, this.getType(), json, configuration);
    }

    @Override
    protected T readObject(InputStream inputStream, ResolvableType type) throws IOException {
        return (T)this.getObjectReader(type).readValue(inputStream);
    }

    @Override
    protected T readObject(Reader reader, ResolvableType type) throws IOException {
        return (T)this.getObjectReader(type).readValue(reader);
    }

    private ObjectReader getObjectReader(ResolvableType type) {
        ObjectReader objectReader = this.objectMapper.readerFor(this.getType(type));
        if (this.view != null) {
            return objectReader.withView(this.view);
        }
        return objectReader;
    }

    @Override
    protected String writeObject(T value, ResolvableType type) throws IOException {
        return this.getObjectWriter(type).writeValueAsString(value);
    }

    private ObjectWriter getObjectWriter(ResolvableType type) {
        ObjectWriter objectWriter = this.objectMapper.writerFor(this.getType(type));
        if (this.view != null) {
            return objectWriter.withView(this.view);
        }
        return objectWriter;
    }

    private JavaType getType(ResolvableType type) {
        return this.objectMapper.constructType(type.getType());
    }

    public static void initFields(Object testInstance, ObjectMapper objectMapper) {
        new Jackson2FieldInitializer().initFields(testInstance, objectMapper);
    }

    public static void initFields(Object testInstance, ObjectFactory<ObjectMapper> objectMapperFactory) {
        new Jackson2FieldInitializer().initFields(testInstance, objectMapperFactory);
    }

    public Jackson2Tester<T> forView(Class<?> view) {
        Class<?> resourceLoadClass = this.getResourceLoadClass();
        ResolvableType type = this.getType();
        Assert.state((resourceLoadClass != null ? 1 : 0) != 0, (String)"'resourceLoadClass' must not be null");
        Assert.state((type != null ? 1 : 0) != 0, (String)"'type' must not be null");
        return new Jackson2Tester<T>(resourceLoadClass, type, this.objectMapper, view);
    }

    private static class Jackson2FieldInitializer
    extends AbstractJsonMarshalTester.FieldInitializer<ObjectMapper> {
        protected Jackson2FieldInitializer() {
            super(Jackson2Tester.class);
        }

        @Override
        protected AbstractJsonMarshalTester<Object> createTester(Class<?> resourceLoadClass, ResolvableType type, ObjectMapper marshaller) {
            return new Jackson2Tester<Object>(resourceLoadClass, type, marshaller);
        }
    }
}

