/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.context;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.testcontainers.context.TestcontainerFieldBeanDefinition;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.testcontainers.containers.Container;

class ContainerFieldsImporter {
    ContainerFieldsImporter() {
    }

    void registerBeanDefinitions(BeanDefinitionRegistry registry, Class<?> definitionClass) {
        for (Field field : this.getContainerFields(definitionClass)) {
            this.assertValid(field);
            Container<?> container = this.getContainer(field);
            this.registerBeanDefinition(registry, field, container);
        }
    }

    private List<Field> getContainerFields(Class<?> containersClass) {
        ArrayList containerFields = new ArrayList();
        ReflectionUtils.doWithFields(containersClass, containerFields::add, this::isContainerField);
        return List.copyOf(containerFields);
    }

    private boolean isContainerField(Field candidate) {
        return Container.class.isAssignableFrom(candidate.getType());
    }

    private void assertValid(Field field) {
        Assert.state((boolean)Modifier.isStatic(field.getModifiers()), () -> "Container field '" + field.getName() + "' must be static");
    }

    private Container<?> getContainer(Field field) {
        ReflectionUtils.makeAccessible((Field)field);
        Container container = (Container)ReflectionUtils.getField((Field)field, null);
        Assert.state((container != null ? 1 : 0) != 0, () -> "Container field '" + field.getName() + "' must not have a null value");
        return container;
    }

    private void registerBeanDefinition(BeanDefinitionRegistry registry, Field field, Container<?> container) {
        TestcontainerFieldBeanDefinition beanDefinition = new TestcontainerFieldBeanDefinition(field, container);
        String beanName = this.generateBeanName(field);
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    private String generateBeanName(Field field) {
        return "importTestContainer.%s.%s".formatted(field.getDeclaringClass().getName(), field.getName());
    }
}

