/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.r2dbc;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.clickhouse.ClickHouseContainer;
import org.testcontainers.clickhouse.ClickHouseR2DBCDatabaseContainer;

class ClickHouseR2dbcContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<ClickHouseContainer, R2dbcConnectionDetails> {
    ClickHouseR2dbcContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, "io.r2dbc.spi.ConnectionFactoryOptions");
    }

    @Override
    public R2dbcConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<ClickHouseContainer> source) {
        return new ClickHouseR2dbcDatabaseContainerConnectionDetails(source);
    }

    private static final class ClickHouseR2dbcDatabaseContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<ClickHouseContainer>
    implements R2dbcConnectionDetails {
        private ClickHouseR2dbcDatabaseContainerConnectionDetails(ContainerConnectionSource<ClickHouseContainer> source) {
            super(source);
        }

        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return ClickHouseR2DBCDatabaseContainer.getOptions((ClickHouseContainer)((ClickHouseContainer)this.getContainer()));
        }
    }
}

