/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.redpanda;

import java.util.List;
import org.springframework.boot.autoconfigure.kafka.KafkaConnectionDetails;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.redpanda.RedpandaContainer;

class RedpandaContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<RedpandaContainer, KafkaConnectionDetails> {
    RedpandaContainerConnectionDetailsFactory() {
    }

    @Override
    protected KafkaConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<RedpandaContainer> source) {
        return new RedpandaContainerConnectionDetails(source);
    }

    private static final class RedpandaContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<RedpandaContainer>
    implements KafkaConnectionDetails {
        private RedpandaContainerConnectionDetails(ContainerConnectionSource<RedpandaContainer> source) {
            super(source);
        }

        public List<String> getBootstrapServers() {
            return List.of(((RedpandaContainer)this.getContainer()).getBootstrapServers());
        }

        @Override
        public SslBundle getSslBundle() {
            return super.getSslBundle();
        }

        public String getSecurityProtocol() {
            return this.getSslBundle() != null ? "SSL" : "PLAINTEXT";
        }
    }
}

