/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.r2dbc;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.MariaDBContainer;
import org.testcontainers.containers.MariaDBR2DBCDatabaseContainer;

class MariaDbR2dbcContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<MariaDBContainer<?>, R2dbcConnectionDetails> {
    MariaDbR2dbcContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, "io.r2dbc.spi.ConnectionFactoryOptions");
    }

    @Override
    public R2dbcConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<MariaDBContainer<?>> source) {
        return new MariaDbR2dbcDatabaseContainerConnectionDetails(source);
    }

    private static final class MariaDbR2dbcDatabaseContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<MariaDBContainer<?>>
    implements R2dbcConnectionDetails {
        private MariaDbR2dbcDatabaseContainerConnectionDetails(ContainerConnectionSource<MariaDBContainer<?>> source) {
            super(source);
        }

        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return MariaDBR2DBCDatabaseContainer.getOptions((MariaDBContainer)((MariaDBContainer)this.getContainer()));
        }
    }
}

