/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.tomcat.servlet;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.Wrapper;
import org.apache.catalina.loader.WebappClassLoaderBase;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.util.LifecycleBase;
import org.apache.catalina.util.SessionConfig;
import org.apache.catalina.webresources.AbstractResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.util.http.CookieProcessor;
import org.apache.tomcat.util.http.Rfc6265CookieProcessor;
import org.apache.tomcat.util.scan.StandardJarScanFilter;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.tomcat.DisableReferenceClearingContextCustomizer;
import org.springframework.boot.tomcat.TomcatContextCustomizer;
import org.springframework.boot.tomcat.TomcatEmbeddedContext;
import org.springframework.boot.tomcat.TomcatEmbeddedWebappClassLoader;
import org.springframework.boot.tomcat.TomcatStarter;
import org.springframework.boot.tomcat.TomcatWebServer;
import org.springframework.boot.tomcat.TomcatWebServerFactory;
import org.springframework.boot.tomcat.servlet.NestedJarResourceSet;
import org.springframework.boot.tomcat.servlet.TldPatterns;
import org.springframework.boot.web.error.ErrorPage;
import org.springframework.boot.web.server.Cookie;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.servlet.ConfigurableServletWebServerFactory;
import org.springframework.boot.web.server.servlet.ContextPath;
import org.springframework.boot.web.server.servlet.CookieSameSiteSupplier;
import org.springframework.boot.web.server.servlet.DocumentRoot;
import org.springframework.boot.web.server.servlet.ServletContextInitializers;
import org.springframework.boot.web.server.servlet.ServletWebServerSettings;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class TomcatServletWebServerFactory
extends TomcatWebServerFactory
implements ConfigurableTomcatWebServerFactory,
ConfigurableServletWebServerFactory,
ResourceLoaderAware {
    private static final Log logger = LogFactory.getLog(TomcatServletWebServerFactory.class);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Set<Class<?>> NO_CLASSES = Collections.emptySet();
    private final ServletWebServerSettings settings = new ServletWebServerSettings();
    private ResourceLoader resourceLoader;
    private Set<String> tldSkipPatterns = new LinkedHashSet<String>(TldPatterns.DEFAULT_SKIP);
    private final Set<String> tldScanPatterns = new LinkedHashSet<String>(TldPatterns.DEFAULT_SCAN);

    public TomcatServletWebServerFactory() {
    }

    public TomcatServletWebServerFactory(int port) {
        super(port);
    }

    public TomcatServletWebServerFactory(String contextPath, int port) {
        super(port);
        this.settings.setContextPath(ContextPath.of((String)contextPath));
    }

    public WebServer getWebServer(ServletContextInitializer ... initializers) {
        Tomcat tomcat = this.createTomcat();
        this.prepareContext(tomcat.getHost(), initializers);
        return this.getTomcatWebServer(tomcat);
    }

    protected void prepareContext(Host host, ServletContextInitializer[] initializers) {
        DocumentRoot documentRoot = new DocumentRoot(logger);
        documentRoot.setDirectory(this.settings.getDocumentRoot());
        File documentRootFile = documentRoot.getValidDirectory();
        TomcatEmbeddedContext context = new TomcatEmbeddedContext();
        LoaderHidingResourceRoot resourceRoot = documentRootFile != null ? new LoaderHidingResourceRoot(context) : new StandardRoot((Context)context);
        this.ignoringNoSuchMethodError(() -> TomcatServletWebServerFactory.lambda$prepareContext$0((WebResourceRoot)resourceRoot));
        context.setResources((WebResourceRoot)resourceRoot);
        String contextPath = this.settings.getContextPath().toString();
        context.setName(contextPath);
        context.setDisplayName(this.settings.getDisplayName());
        context.setPath(contextPath);
        File docBase = documentRootFile != null ? documentRootFile : this.createTempDir("tomcat-docbase");
        context.setDocBase(docBase.getAbsolutePath());
        context.addLifecycleListener((LifecycleListener)new Tomcat.FixContextListener());
        ClassLoader parentClassLoader = this.resourceLoader != null ? this.resourceLoader.getClassLoader() : ClassUtils.getDefaultClassLoader();
        context.setParentClassLoader(parentClassLoader);
        this.resetDefaultLocaleMapping(context);
        this.addLocaleMappings(context);
        context.setCreateUploadTargets(true);
        this.configureTldPatterns(context);
        WebappLoader loader = new WebappLoader();
        loader.setLoaderInstance((WebappClassLoaderBase)new TomcatEmbeddedWebappClassLoader(parentClassLoader));
        loader.setDelegate(true);
        context.setLoader((Loader)loader);
        if (this.settings.isRegisterDefaultServlet()) {
            this.addDefaultServlet((Context)context);
        }
        if (this.shouldRegisterJspServlet()) {
            this.addJspServlet((Context)context);
            this.addJasperInitializer(context);
        }
        context.addLifecycleListener(new StaticResourceConfigurer((Context)context));
        ServletContextInitializers initializersToUse = ServletContextInitializers.from((ServletWebServerSettings)this.settings, (ServletContextInitializer[])initializers);
        host.addChild((Container)context);
        this.configureContext((Context)context, (Iterable<ServletContextInitializer>)initializersToUse);
        this.postProcessContext((Context)context);
    }

    private void ignoringNoSuchMethodError(Runnable method) {
        try {
            method.run();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private boolean shouldRegisterJspServlet() {
        return this.settings.getJsp() != null && this.settings.getJsp().getRegistered() && ClassUtils.isPresent((String)this.settings.getJsp().getClassName(), (ClassLoader)this.getClass().getClassLoader());
    }

    private void resetDefaultLocaleMapping(TomcatEmbeddedContext context) {
        context.addLocaleEncodingMappingParameter(Locale.ENGLISH.toString(), DEFAULT_CHARSET.displayName());
        context.addLocaleEncodingMappingParameter(Locale.FRENCH.toString(), DEFAULT_CHARSET.displayName());
        context.addLocaleEncodingMappingParameter(Locale.JAPANESE.toString(), DEFAULT_CHARSET.displayName());
    }

    private void addLocaleMappings(TomcatEmbeddedContext context) {
        this.settings.getLocaleCharsetMappings().forEach((locale, charset) -> context.addLocaleEncodingMappingParameter(locale.toString(), charset.toString()));
    }

    private void configureTldPatterns(TomcatEmbeddedContext context) {
        StandardJarScanFilter filter = new StandardJarScanFilter();
        filter.setTldSkip(StringUtils.collectionToCommaDelimitedString(this.tldSkipPatterns));
        filter.setTldScan(StringUtils.collectionToCommaDelimitedString(this.tldScanPatterns));
        context.getJarScanner().setJarScanFilter((JarScanFilter)filter);
    }

    private void addDefaultServlet(Context context) {
        Wrapper defaultServlet = context.createWrapper();
        defaultServlet.setName("default");
        defaultServlet.setServletClass("org.apache.catalina.servlets.DefaultServlet");
        defaultServlet.addInitParameter("debug", "0");
        defaultServlet.addInitParameter("listings", "false");
        defaultServlet.setLoadOnStartup(1);
        defaultServlet.setOverridable(true);
        context.addChild((Container)defaultServlet);
        context.addServletMappingDecoded("/", "default");
    }

    private void addJspServlet(Context context) {
        Wrapper jspServlet = context.createWrapper();
        jspServlet.setName("jsp");
        jspServlet.setServletClass(this.settings.getJsp().getClassName());
        jspServlet.addInitParameter("fork", "false");
        this.settings.getJsp().getInitParameters().forEach((arg_0, arg_1) -> ((Wrapper)jspServlet).addInitParameter(arg_0, arg_1));
        jspServlet.setLoadOnStartup(3);
        context.addChild((Container)jspServlet);
        context.addServletMappingDecoded("*.jsp", "jsp");
        context.addServletMappingDecoded("*.jspx", "jsp");
    }

    private void addJasperInitializer(TomcatEmbeddedContext context) {
        try {
            ServletContainerInitializer initializer = (ServletContainerInitializer)ClassUtils.forName((String)"org.apache.jasper.servlet.JasperInitializer", null).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            context.addServletContainerInitializer(initializer, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void configureContext(Context context, Iterable<ServletContextInitializer> initializers) {
        TomcatStarter starter = new TomcatStarter(initializers);
        if (context instanceof TomcatEmbeddedContext) {
            TomcatEmbeddedContext embeddedContext = (TomcatEmbeddedContext)context;
            embeddedContext.setStarter(starter);
            embeddedContext.setFailCtxIfServletStartFails(true);
        }
        context.addServletContainerInitializer((ServletContainerInitializer)starter, NO_CLASSES);
        for (LifecycleListener lifecycleListener : this.getContextLifecycleListeners()) {
            context.addLifecycleListener(lifecycleListener);
        }
        for (Valve valve : this.getContextValves()) {
            context.getPipeline().addValve(valve);
        }
        for (ErrorPage errorPage : this.getErrorPages()) {
            org.apache.tomcat.util.descriptor.web.ErrorPage tomcatErrorPage = new org.apache.tomcat.util.descriptor.web.ErrorPage();
            tomcatErrorPage.setLocation(errorPage.getPath());
            tomcatErrorPage.setErrorCode(errorPage.getStatusCode());
            tomcatErrorPage.setExceptionType(errorPage.getExceptionName());
            context.addErrorPage(tomcatErrorPage);
        }
        this.setMimeMappings(context);
        this.configureSession(context);
        this.configureCookieProcessor(context);
        new DisableReferenceClearingContextCustomizer().customize(context);
        for (String webListenerClassName : this.getSettings().getWebListenerClassNames()) {
            context.addApplicationListener(webListenerClassName);
        }
        for (TomcatContextCustomizer customizer : this.getContextCustomizers()) {
            customizer.customize(context);
        }
    }

    private void configureSession(Context context) {
        long sessionTimeout = this.getSessionTimeoutInMinutes();
        context.setSessionTimeout((int)sessionTimeout);
        Boolean httpOnly = this.settings.getSession().getCookie().getHttpOnly();
        if (httpOnly != null) {
            context.setUseHttpOnly(httpOnly.booleanValue());
        }
        if (this.settings.getSession().isPersistent()) {
            Manager manager = context.getManager();
            if (manager == null) {
                manager = new StandardManager();
                context.setManager(manager);
            }
            this.configurePersistSession(manager);
        } else {
            context.addLifecycleListener((LifecycleListener)new DisablePersistSessionListener());
        }
    }

    private void setMimeMappings(Context context) {
        MimeMappings mimeMappings = this.settings.getMimeMappings();
        if (context instanceof TomcatEmbeddedContext) {
            TomcatEmbeddedContext embeddedContext = (TomcatEmbeddedContext)context;
            embeddedContext.setMimeMappings(mimeMappings);
            return;
        }
        for (MimeMappings.Mapping mapping : mimeMappings) {
            context.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
        }
    }

    private void configureCookieProcessor(Context context) {
        Cookie.SameSite sessionSameSite = this.settings.getSession().getCookie().getSameSite();
        ArrayList<CookieSameSiteSupplier> suppliers = new ArrayList<CookieSameSiteSupplier>();
        if (sessionSameSite != null) {
            suppliers.add(CookieSameSiteSupplier.of((Cookie.SameSite)sessionSameSite).whenHasName(() -> SessionConfig.getSessionCookieName((Context)context)));
        }
        if (!CollectionUtils.isEmpty((Collection)this.settings.getCookieSameSiteSuppliers())) {
            suppliers.addAll(this.settings.getCookieSameSiteSuppliers());
        }
        if (!suppliers.isEmpty()) {
            context.setCookieProcessor((CookieProcessor)new SuppliedSameSiteCookieProcessor(suppliers));
        }
    }

    private void configurePersistSession(Manager manager) {
        Assert.state((boolean)(manager instanceof StandardManager), () -> "Unable to persist HTTP session state using manager type " + manager.getClass().getName());
        File dir = this.settings.getSession().getSessionStoreDirectory().getValidDirectory(true);
        File file = new File(dir, "SESSIONS.ser");
        ((StandardManager)manager).setPathname(file.getAbsolutePath());
    }

    private long getSessionTimeoutInMinutes() {
        Duration sessionTimeout = this.settings.getSession().getTimeout();
        if (this.isZeroOrLess(sessionTimeout)) {
            return 0L;
        }
        return Math.max(sessionTimeout.toMinutes(), 1L);
    }

    private boolean isZeroOrLess(@Nullable Duration sessionTimeout) {
        return sessionTimeout == null || sessionTimeout.isNegative() || sessionTimeout.isZero();
    }

    protected void postProcessContext(Context context) {
    }

    protected TomcatWebServer getTomcatWebServer(Tomcat tomcat) {
        return new TomcatWebServer(tomcat, this.getPort() >= 0, this.getShutdown());
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Set<String> getTldSkipPatterns() {
        return this.tldSkipPatterns;
    }

    public void setTldSkipPatterns(Collection<String> patterns) {
        Assert.notNull(patterns, (String)"'patterns' must not be null");
        this.tldSkipPatterns = new LinkedHashSet<String>(patterns);
    }

    public void addTldSkipPatterns(String ... patterns) {
        Assert.notNull((Object)patterns, (String)"'patterns' must not be null");
        this.tldSkipPatterns.addAll(Arrays.asList(patterns));
    }

    public ServletWebServerSettings getSettings() {
        return this.settings;
    }

    private static /* synthetic */ void lambda$prepareContext$0(WebResourceRoot resourceRoot) {
        resourceRoot.setReadOnly(true);
    }

    private static final class LoaderHidingResourceRoot
    extends StandardRoot {
        private LoaderHidingResourceRoot(TomcatEmbeddedContext context) {
            super((Context)context);
        }

        protected WebResourceSet createMainResourceSet() {
            return new LoaderHidingWebResourceSet(super.createMainResourceSet());
        }
    }

    private final class StaticResourceConfigurer
    implements LifecycleListener {
        private static final String WEB_APP_MOUNT = "/";
        private static final String INTERNAL_PATH = "/META-INF/resources";
        private final Context context;

        private StaticResourceConfigurer(Context context) {
            this.context = context;
        }

        public void lifecycleEvent(LifecycleEvent event) {
            if (event.getType().equals("before_init")) {
                this.addResourceJars(TomcatServletWebServerFactory.this.getSettings().getStaticResourceUrls());
            }
        }

        private void addResourceJars(List<URL> resourceJarUrls) {
            for (URL url : resourceJarUrls) {
                String path = url.getPath();
                if (path.endsWith(".jar") || path.endsWith(".jar!/")) {
                    Object jar = url.toString();
                    if (!((String)jar).startsWith("jar:")) {
                        jar = "jar:" + (String)jar + "!/";
                    }
                    this.addResourceSet((String)jar);
                    continue;
                }
                this.addResourceSet(url.toString());
            }
            for (WebResourceSet resources : this.context.getResources().getJarResources()) {
                resources.setReadOnly(true);
            }
        }

        private void addResourceSet(String resource) {
            try {
                if (this.isInsideClassicNestedJar(resource)) {
                    this.addClassicNestedResourceSet(resource);
                    return;
                }
                WebResourceRoot root = this.context.getResources();
                URL url = new URL(resource);
                if (this.isInsideNestedJar(resource)) {
                    root.addJarResources((WebResourceSet)new NestedJarResourceSet(url, root, WEB_APP_MOUNT, INTERNAL_PATH));
                } else {
                    root.createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, WEB_APP_MOUNT, url, INTERNAL_PATH);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void addClassicNestedResourceSet(String resource) throws MalformedURLException {
            URL url = new URL(resource.substring(0, resource.length() - 2));
            this.context.getResources().createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, WEB_APP_MOUNT, url, INTERNAL_PATH);
        }

        private boolean isInsideClassicNestedJar(String resource) {
            return !this.isInsideNestedJar(resource) && resource.indexOf("!/") < resource.lastIndexOf("!/");
        }

        private boolean isInsideNestedJar(String resource) {
            return resource.startsWith("jar:nested:");
        }
    }

    private static final class DisablePersistSessionListener
    implements LifecycleListener {
        private DisablePersistSessionListener() {
        }

        public void lifecycleEvent(LifecycleEvent event) {
            Context context;
            Manager manager;
            if (event.getType().equals("start") && (manager = (context = (Context)event.getLifecycle()).getManager()) instanceof StandardManager) {
                StandardManager standardManager = (StandardManager)manager;
                standardManager.setPathname(null);
            }
        }
    }

    private static class SuppliedSameSiteCookieProcessor
    extends Rfc6265CookieProcessor {
        private final List<CookieSameSiteSupplier> suppliers;

        SuppliedSameSiteCookieProcessor(List<CookieSameSiteSupplier> suppliers) {
            this.suppliers = suppliers;
        }

        public String generateHeader(Cookie cookie, HttpServletRequest request) {
            String sameSiteValue;
            Cookie.SameSite sameSite = this.getSameSite(cookie);
            String string = sameSiteValue = sameSite != null ? sameSite.attributeValue() : null;
            if (sameSiteValue == null) {
                return super.generateHeader(cookie, request);
            }
            Rfc6265CookieProcessor delegate = new Rfc6265CookieProcessor();
            delegate.setSameSiteCookies(sameSiteValue);
            return delegate.generateHeader(cookie, request);
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable Cookie.SameSite getSameSite(Cookie cookie) {
            for (CookieSameSiteSupplier supplier : this.suppliers) {
                Cookie.SameSite sameSite = supplier.getSameSite(cookie);
                if (sameSite == null) continue;
                return sameSite;
            }
            return null;
        }
    }

    private static final class LoaderHidingWebResourceSet
    extends AbstractResourceSet {
        private final WebResourceSet delegate;
        private final Method initInternal;

        private LoaderHidingWebResourceSet(WebResourceSet delegate) {
            this.delegate = delegate;
            try {
                this.initInternal = LifecycleBase.class.getDeclaredMethod("initInternal", new Class[0]);
                this.initInternal.setAccessible(true);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        public WebResource getResource(String path) {
            if (path.startsWith("/org/springframework/boot")) {
                return new EmptyResource(this.getRoot(), path);
            }
            return this.delegate.getResource(path);
        }

        public String[] list(String path) {
            return this.delegate.list(path);
        }

        public Set<String> listWebAppPaths(String path) {
            return this.delegate.listWebAppPaths(path).stream().filter(webAppPath -> !webAppPath.startsWith("/org/springframework/boot")).collect(Collectors.toSet());
        }

        public boolean mkdir(String path) {
            return this.delegate.mkdir(path);
        }

        public boolean write(String path, InputStream is, boolean overwrite) {
            return this.delegate.write(path, is, overwrite);
        }

        public URL getBaseUrl() {
            return this.delegate.getBaseUrl();
        }

        public void setReadOnly(boolean readOnly) {
            this.delegate.setReadOnly(readOnly);
        }

        public boolean isReadOnly() {
            return this.delegate.isReadOnly();
        }

        public void gc() {
            this.delegate.gc();
        }

        public void setAllowLinking(boolean allowLinking) {
            this.delegate.setAllowLinking(allowLinking);
        }

        public boolean getAllowLinking() {
            return this.delegate.getAllowLinking();
        }

        protected void initInternal() throws LifecycleException {
            if (this.delegate instanceof LifecycleBase) {
                try {
                    ReflectionUtils.invokeMethod((Method)this.initInternal, (Object)this.delegate);
                }
                catch (Exception ex) {
                    throw new LifecycleException((Throwable)ex);
                }
            }
        }
    }
}

