/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.io.File;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.ProtectionDomain;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

class StartupInfoLogger {
    private final Class<?> sourceClass;

    public StartupInfoLogger(Class<?> sourceClass) {
        this.sourceClass = sourceClass;
    }

    public void logStarting(Log log) {
        Assert.notNull((Object)log, (String)"Log must not be null");
        if (log.isInfoEnabled()) {
            log.info((Object)this.getStartupMessage());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this.getRunningMessage());
        }
    }

    public void logStarted(Log log, StopWatch stopWatch) {
        if (log.isInfoEnabled()) {
            log.info((Object)this.getStartedMessage(stopWatch));
        }
    }

    private String getStartupMessage() {
        StringBuilder message = new StringBuilder();
        message.append("Starting ");
        message.append(this.getApplicationName());
        message.append(this.getVersion(this.sourceClass));
        message.append(this.getOn());
        message.append(this.getPid());
        message.append(this.getContext());
        return message.toString();
    }

    private StringBuilder getRunningMessage() {
        StringBuilder message = new StringBuilder();
        message.append("Running with Spring Bootstrap");
        message.append(this.getVersion(SpringApplication.class));
        message.append(", Spring");
        message.append(this.getVersion(ApplicationContext.class));
        return message;
    }

    private StringBuilder getStartedMessage(StopWatch stopWatch) {
        StringBuilder message = new StringBuilder();
        message.append("Started ");
        message.append(this.getApplicationName());
        message.append(" in ");
        message.append(stopWatch.getTotalTimeSeconds());
        message.append(" seconds");
        return message;
    }

    private String getApplicationName() {
        return this.sourceClass != null ? ClassUtils.getShortName(this.sourceClass) : "application";
    }

    private String getVersion(final Class<?> source) {
        return this.getValue(" v", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return source.getPackage().getImplementationVersion();
            }
        }, "");
    }

    private String getOn() {
        return this.getValue(" on ", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return InetAddress.getLocalHost().getHostName();
            }
        });
    }

    private String getPid() {
        return this.getValue(" with PID ", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return System.getProperty("PID");
            }
        });
    }

    private String getContext() {
        String path;
        String startedBy = this.getValue("started by ", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return System.getProperty("user.name");
            }
        });
        File codeSourceLocation = this.getCodeSourceLocation();
        String string = path = codeSourceLocation == null ? "" : codeSourceLocation.getAbsolutePath();
        if (startedBy == null && codeSourceLocation == null) {
            return "";
        }
        if (StringUtils.hasLength((String)startedBy) && StringUtils.hasLength((String)path)) {
            startedBy = " " + startedBy;
        }
        return " (" + path + startedBy + ")";
    }

    private File getCodeSourceLocation() {
        try {
            ProtectionDomain protectionDomain = (this.sourceClass == null ? this.getClass() : this.sourceClass).getProtectionDomain();
            URL location = protectionDomain.getCodeSource().getLocation();
            URLConnection connection = location.openConnection();
            File file = connection instanceof JarURLConnection ? new File(((JarURLConnection)connection).getJarFile().getName()) : new File(location.getPath());
            if (file.exists()) {
                return file;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getValue(String prefix, Callable<Object> call) {
        return this.getValue(prefix, call, "");
    }

    private String getValue(String prefix, Callable<Object> call, String defaultValue) {
        try {
            Object value = call.call();
            if (value != null && StringUtils.hasLength((String)value.toString())) {
                return prefix + value;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return defaultValue;
    }
}

