/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.properties;

import java.io.File;
import java.net.InetAddress;
import javax.validation.constraints.NotNull;
import org.apache.catalina.Context;
import org.apache.catalina.Valve;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.valves.RemoteIpValve;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(name="server", ignoreUnknownFields=false)
public class ServerProperties
implements EmbeddedServletContainerCustomizer {
    private int port = 8080;
    private InetAddress address;
    private int sessionTimeout = 30;
    @NotNull
    private String contextPath = "";
    private Tomcat tomcat = new Tomcat();

    public Tomcat getTomcat() {
        return this.tomcat;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setLoader(String value) {
    }

    @Override
    public void customize(ConfigurableEmbeddedServletContainerFactory factory) {
        factory.setPort(this.getPort());
        factory.setAddress(this.getAddress());
        factory.setContextPath(this.getContextPath());
        factory.setSessionTimeout(this.getSessionTimeout());
        if (factory instanceof TomcatEmbeddedServletContainerFactory) {
            this.getTomcat().customizeTomcat((TomcatEmbeddedServletContainerFactory)factory);
        }
    }

    public static class Tomcat {
        private String accessLogPattern;
        private boolean accessLogEnabled = false;
        private String protocolHeader = "x-forwarded-proto";
        private String remoteIpHeader = "x-forwarded-for";
        private File basedir;
        private int backgroundProcessorDelay = 30;

        public boolean getAccessLogEnabled() {
            return this.accessLogEnabled;
        }

        public void setAccessLogEnabled(boolean accessLogEnabled) {
            this.accessLogEnabled = accessLogEnabled;
        }

        public int getBackgroundProcessorDelay() {
            return this.backgroundProcessorDelay;
        }

        public void setBackgroundProcessorDelay(int backgroundProcessorDelay) {
            this.backgroundProcessorDelay = backgroundProcessorDelay;
        }

        public File getBasedir() {
            return this.basedir;
        }

        public void setBasedir(File basedir) {
            this.basedir = basedir;
        }

        public String getAccessLogPattern() {
            return this.accessLogPattern;
        }

        public void setAccessLogPattern(String accessLogPattern) {
            this.accessLogPattern = accessLogPattern;
        }

        public String getProtocolHeader() {
            return this.protocolHeader;
        }

        public void setProtocolHeader(String protocolHeader) {
            this.protocolHeader = protocolHeader;
        }

        public String getRemoteIpHeader() {
            return this.remoteIpHeader;
        }

        public void setRemoteIpHeader(String remoteIpHeader) {
            this.remoteIpHeader = remoteIpHeader;
        }

        void customizeTomcat(TomcatEmbeddedServletContainerFactory factory) {
            RemoteIpValve valve;
            if (this.getBasedir() != null) {
                factory.setBaseDirectory(this.getBasedir());
            }
            factory.addContextCustomizers(new TomcatContextCustomizer(){

                @Override
                public void customize(Context context) {
                    context.setBackgroundProcessorDelay(Tomcat.this.backgroundProcessorDelay);
                }
            });
            String remoteIpHeader = this.getRemoteIpHeader();
            String protocolHeader = this.getProtocolHeader();
            if (StringUtils.hasText((String)remoteIpHeader) || StringUtils.hasText((String)protocolHeader)) {
                valve = new RemoteIpValve();
                valve.setRemoteIpHeader(remoteIpHeader);
                valve.setProtocolHeader(protocolHeader);
                factory.addContextValves(new Valve[]{valve});
            }
            if (this.accessLogEnabled) {
                valve = new AccessLogValve();
                String accessLogPattern = this.getAccessLogPattern();
                if (accessLogPattern != null) {
                    valve.setPattern(accessLogPattern);
                } else {
                    valve.setPattern("common");
                }
                valve.setSuffix(".log");
                factory.addContextValves(new Valve[]{valve});
            }
        }
    }
}

