/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web;

import java.util.EventListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.embedded.AnnotationConfigEmbeddedWebApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public abstract class SpringBootServletInitializer
implements WebApplicationInitializer {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public void onStartup(ServletContext servletContext) throws ServletException {
        WebApplicationContext rootAppContext = this.createRootApplicationContext(servletContext);
        if (rootAppContext != null) {
            servletContext.addListener((EventListener)new ContextLoaderListener(rootAppContext){

                public void contextInitialized(ServletContextEvent event) {
                }
            });
        } else {
            this.logger.debug((Object)"No ContextLoaderListener registered, as createRootApplicationContext() did not return an application context");
        }
    }

    protected WebApplicationContext createRootApplicationContext(ServletContext servletContext) {
        ApplicationContext parent = null;
        Object object = servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (object instanceof ApplicationContext) {
            this.logger.info((Object)"Root context already created (using as parent).");
            parent = (ApplicationContext)object;
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, null);
        }
        SpringApplication application = new SpringApplication(this.getConfigClasses());
        AnnotationConfigEmbeddedWebApplicationContext context = new AnnotationConfigEmbeddedWebApplicationContext();
        context.setParent(parent);
        context.setServletContext(servletContext);
        application.setApplicationContext((ApplicationContext)context);
        return (WebApplicationContext)application.run(new String[0]);
    }

    protected abstract Class<?>[] getConfigClasses();
}

