/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

public class OverrideSourcesTests {
    @Test
    public void beanInjectedToMainConfiguration() {
        ConfigurableApplicationContext context = SpringApplication.run((Object[])new Object[]{MainConfiguration.class}, (String[])new String[]{"--spring.main.web_environment=false"});
        Assert.assertEquals((Object)"foo", (Object)((Service)context.getBean(Service.class)).bean.name);
    }

    @Test
    public void primaryBeanInjectedProvingSourcesNotOverridden() {
        ConfigurableApplicationContext context = SpringApplication.run((Object[])new Object[]{MainConfiguration.class, TestConfiguration.class}, (String[])new String[]{"--spring.main.web_environment=false", "--spring.main.sources=org.springframework.boot.OverrideSourcesTests.MainConfiguration"});
        Assert.assertEquals((Object)"bar", (Object)((Service)context.getBean(Service.class)).bean.name);
    }

    protected static class TestBean {
        private String name;

        public TestBean(String name) {
            this.name = name;
        }
    }

    protected static class Service {
        @Autowired
        private TestBean bean;

        protected Service() {
        }
    }

    @Configuration
    protected static class MainConfiguration {
        protected MainConfiguration() {
        }

        @Bean
        public TestBean first() {
            return new TestBean("foo");
        }

        @Bean
        public Service Service() {
            return new Service();
        }
    }

    @Configuration
    protected static class TestConfiguration {
        protected TestConfiguration() {
        }

        @Bean
        @Primary
        public TestBean another() {
            return new TestBean("bar");
        }
    }
}

