/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.boot.BeanDefinitionLoader;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.embedded.AnnotationConfigEmbeddedWebApplicationContext;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.CommandLinePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.util.StringUtils;

public class SpringApplicationTests {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private ConfigurableApplicationContext context;

    private Environment getEnvironment() {
        if (this.context != null) {
            return this.context.getEnvironment();
        }
        throw new IllegalStateException("Could not obtain Environment");
    }

    @After
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    @Test
    public void sourcesMustNotBeNull() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Sources must not be empty");
        new SpringApplication((Object[])null).run(new String[0]);
    }

    @Test
    public void sourcesMustNotBeEmpty() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Sources must not be empty");
        new SpringApplication(new Object[0]).run(new String[0]);
    }

    @Test
    public void disableBanner() throws Exception {
        SpringApplication application = (SpringApplication)Mockito.spy((Object)new SpringApplication(new Object[]{ExampleConfig.class}));
        application.setWebEnvironment(false);
        application.setShowBanner(false);
        application.run(new String[0]);
        ((SpringApplication)Mockito.verify((Object)application, (VerificationMode)Mockito.never())).printBanner();
    }

    @Test
    public void customBanner() throws Exception {
        SpringApplication application = (SpringApplication)Mockito.spy((Object)new SpringApplication(new Object[]{ExampleConfig.class}));
        application.setWebEnvironment(false);
        application.run(new String[0]);
        ((SpringApplication)Mockito.verify((Object)application)).printBanner();
    }

    @Test
    public void specificApplicationContextClass() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{ExampleConfig.class});
        application.setApplicationContextClass(StaticApplicationContext.class);
        this.context = application.run(new String[0]);
        Assert.assertThat((Object)this.context, (Matcher)Matchers.instanceOf(StaticApplicationContext.class));
    }

    @Test
    public void specificApplicationContextInitializer() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{ExampleConfig.class});
        application.setWebEnvironment(false);
        final AtomicReference reference = new AtomicReference();
        application.setInitializers(Arrays.asList(new ApplicationContextInitializer<ConfigurableApplicationContext>(){

            public void initialize(ConfigurableApplicationContext context) {
                reference.set(context);
            }
        }));
        this.context = application.run(new String[]{"--foo=bar"});
        Assert.assertThat((Object)this.context, (Matcher)Matchers.sameInstance(reference.get()));
        Assert.assertThat((Object)this.getEnvironment().getProperty("foo"), (Matcher)Matchers.equalTo((Object)"bar"));
    }

    @Test
    public void defaultApplicationContext() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{ExampleConfig.class});
        application.setWebEnvironment(false);
        this.context = application.run(new String[0]);
        Assert.assertThat((Object)this.context, (Matcher)Matchers.instanceOf(AnnotationConfigApplicationContext.class));
    }

    @Test
    public void defaultApplicationContextForWeb() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{ExampleWebConfig.class});
        application.setWebEnvironment(true);
        this.context = application.run(new String[0]);
        Assert.assertThat((Object)this.context, (Matcher)Matchers.instanceOf(AnnotationConfigEmbeddedWebApplicationContext.class));
    }

    @Test
    public void customEnvironment() throws Exception {
        TestSpringApplication application = new TestSpringApplication(ExampleConfig.class);
        application.setWebEnvironment(false);
        StandardEnvironment environment = new StandardEnvironment();
        application.setEnvironment((ConfigurableEnvironment)environment);
        application.run(new String[0]);
        ((BeanDefinitionLoader)Mockito.verify((Object)application.getLoader())).setEnvironment((ConfigurableEnvironment)environment);
    }

    @Test
    public void customResourceLoader() throws Exception {
        TestSpringApplication application = new TestSpringApplication(ExampleConfig.class);
        application.setWebEnvironment(false);
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        application.setResourceLoader((ResourceLoader)resourceLoader);
        this.context = application.run(new String[0]);
        ((BeanDefinitionLoader)Mockito.verify((Object)application.getLoader())).setResourceLoader((ResourceLoader)resourceLoader);
    }

    @Test
    public void customResourceLoaderFromConstructor() throws Exception {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        TestSpringApplication application = new TestSpringApplication((ResourceLoader)resourceLoader, new Object[]{ExampleWebConfig.class});
        this.context = application.run(new String[0]);
        ((BeanDefinitionLoader)Mockito.verify((Object)application.getLoader())).setResourceLoader((ResourceLoader)resourceLoader);
    }

    @Test
    public void customBeanNameGenerator() throws Exception {
        TestSpringApplication application = new TestSpringApplication(ExampleWebConfig.class);
        DefaultBeanNameGenerator beanNameGenerator = new DefaultBeanNameGenerator();
        application.setBeanNameGenerator((BeanNameGenerator)beanNameGenerator);
        this.context = application.run(new String[0]);
        ((BeanDefinitionLoader)Mockito.verify((Object)application.getLoader())).setBeanNameGenerator((BeanNameGenerator)beanNameGenerator);
        Assert.assertThat((Object)this.context.getBean("org.springframework.context.annotation.internalConfigurationBeanNameGenerator"), (Matcher)Matchers.sameInstance((Object)beanNameGenerator));
    }

    @Test
    public void commandLinePropertySource() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{ExampleConfig.class});
        application.setWebEnvironment(false);
        StandardEnvironment environment = new StandardEnvironment();
        application.setEnvironment((ConfigurableEnvironment)environment);
        application.run(new String[0]);
        Assert.assertThat((Object)this.hasPropertySource((ConfigurableEnvironment)environment, CommandLinePropertySource.class, "commandLineArgs"), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void disableCommandLinePropertySource() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{ExampleConfig.class});
        application.setWebEnvironment(false);
        application.setAddCommandLineProperties(false);
        StandardEnvironment environment = new StandardEnvironment();
        application.setEnvironment((ConfigurableEnvironment)environment);
        application.run(new String[0]);
        Assert.assertThat((Object)this.hasPropertySource((ConfigurableEnvironment)environment, MapPropertySource.class, "commandLineArgs"), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void runCommandLineRunners() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{CommandLineRunConfig.class});
        application.setWebEnvironment(false);
        this.context = application.run(new String[]{"arg"});
        Assert.assertTrue((boolean)((TestCommandLineRunner)this.context.getBean("runnerA", TestCommandLineRunner.class)).hasRun());
        Assert.assertTrue((boolean)((TestCommandLineRunner)this.context.getBean("runnerB", TestCommandLineRunner.class)).hasRun());
    }

    @Test
    public void loadSources() throws Exception {
        Object[] sources = new Object[]{ExampleConfig.class, "a", TestCommandLineRunner.class};
        TestSpringApplication application = new TestSpringApplication(sources);
        application.setWebEnvironment(false);
        application.setUseMockLoader(true);
        application.run(new String[0]);
        Set initialSources = (Set)ReflectionTestUtils.getField((Object)((Object)application), (String)"initialSources");
        Assert.assertThat((Object)initialSources.toArray(), (Matcher)Matchers.equalTo((Object)sources));
    }

    @Test
    public void wildcardSources() {
        Object[] sources = new Object[]{"classpath:org/springframework/boot/sample-${sample.app.test.prop}.xml"};
        TestSpringApplication application = new TestSpringApplication(sources);
        application.setWebEnvironment(false);
        application.run(new String[0]);
    }

    @Test
    public void run() throws Exception {
        this.context = SpringApplication.run(ExampleWebConfig.class, (String[])new String[0]);
        Assert.assertNotNull((Object)this.context);
    }

    @Test
    public void runComponents() throws Exception {
        this.context = SpringApplication.run((Object[])new Object[]{ExampleWebConfig.class, Object.class}, (String[])new String[0]);
        Assert.assertNotNull((Object)this.context);
    }

    @Test
    public void exit() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{ExampleConfig.class});
        application.setWebEnvironment(false);
        ConfigurableApplicationContext context = application.run(new String[0]);
        Assert.assertNotNull((Object)context);
        Assert.assertEquals((long)0L, (long)SpringApplication.exit((ApplicationContext)context, (ExitCodeGenerator[])new ExitCodeGenerator[0]));
    }

    @Test
    public void exitWithExplicitCode() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{ExampleConfig.class});
        application.setWebEnvironment(false);
        ConfigurableApplicationContext context = application.run(new String[0]);
        Assert.assertNotNull((Object)context);
        Assert.assertEquals((long)2L, (long)SpringApplication.exit((ApplicationContext)context, (ExitCodeGenerator[])new ExitCodeGenerator[]{new ExitCodeGenerator(){

            public int getExitCode() {
                return 2;
            }
        }}));
    }

    @Test
    public void defaultCommandLineArgs() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{ExampleConfig.class});
        application.setDefaultProperties(StringUtils.splitArrayElementsIntoProperties((String[])new String[]{"baz=", "bar=spam"}, (String)"="));
        application.setWebEnvironment(false);
        this.context = application.run(new String[]{"--bar=foo", "bucket", "crap"});
        Assert.assertThat((Object)this.context, (Matcher)Matchers.instanceOf(AnnotationConfigApplicationContext.class));
        Assert.assertThat((Object)this.getEnvironment().getProperty("bar"), (Matcher)Matchers.equalTo((Object)"foo"));
        Assert.assertThat((Object)this.getEnvironment().getProperty("baz"), (Matcher)Matchers.equalTo((Object)""));
    }

    @Test
    public void commandLineArgsApplyToSpringApplication() throws Exception {
        TestSpringApplication application = new TestSpringApplication(ExampleConfig.class);
        application.setWebEnvironment(false);
        application.run(new String[]{"--spring.main.show_banner=false"});
        Assert.assertThat((Object)application.getShowBanner(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void registerShutdownHook() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{ExampleConfig.class});
        application.setApplicationContextClass(SpyApplicationContext.class);
        this.context = application.run(new String[0]);
        SpyApplicationContext applicationContext = (SpyApplicationContext)this.context;
        ((ConfigurableApplicationContext)Mockito.verify((Object)applicationContext.getApplicationContext())).registerShutdownHook();
    }

    private boolean hasPropertySource(ConfigurableEnvironment environment, Class<?> propertySourceClass, String name) {
        for (PropertySource source : environment.getPropertySources()) {
            if (!propertySourceClass.isInstance(source) || name != null && !name.equals(source.getName())) continue;
            return true;
        }
        return false;
    }

    static class TestCommandLineRunner
    implements CommandLineRunner,
    ApplicationContextAware,
    Ordered {
        private String[] expectedBefore;
        private ApplicationContext applicationContext;
        private String[] args;
        private int order;

        public TestCommandLineRunner(int order, String ... expectedBefore) {
            this.expectedBefore = expectedBefore;
            this.order = order;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }

        public int getOrder() {
            return this.order;
        }

        public void run(String ... args) {
            this.args = args;
            for (String name : this.expectedBefore) {
                TestCommandLineRunner bean = (TestCommandLineRunner)this.applicationContext.getBean(name, TestCommandLineRunner.class);
                Assert.assertTrue((boolean)bean.hasRun());
            }
        }

        public boolean hasRun() {
            return this.args != null;
        }
    }

    @Configuration
    static class CommandLineRunConfig {
        CommandLineRunConfig() {
        }

        @Bean
        public TestCommandLineRunner runnerB() {
            return new TestCommandLineRunner(Integer.MAX_VALUE, "runnerA");
        }

        @Bean
        public TestCommandLineRunner runnerA() {
            return new TestCommandLineRunner(Integer.MIN_VALUE, new String[0]);
        }
    }

    @Configuration
    static class ExampleWebConfig {
        ExampleWebConfig() {
        }

        @Bean
        public JettyEmbeddedServletContainerFactory container() {
            return new JettyEmbeddedServletContainerFactory();
        }
    }

    @Configuration
    static class ExampleConfig {
        ExampleConfig() {
        }
    }

    private static class TestSpringApplication
    extends SpringApplication {
        private BeanDefinitionLoader loader;
        private boolean useMockLoader;
        private boolean showBanner;

        public TestSpringApplication(Object ... sources) {
            super(sources);
        }

        public TestSpringApplication(ResourceLoader resourceLoader, Object ... sources) {
            super(resourceLoader, sources);
        }

        public void setUseMockLoader(boolean useMockLoader) {
            this.useMockLoader = useMockLoader;
        }

        protected BeanDefinitionLoader createBeanDefinitionLoader(BeanDefinitionRegistry registry, Object[] sources) {
            this.loader = this.useMockLoader ? (BeanDefinitionLoader)Mockito.mock(BeanDefinitionLoader.class) : (BeanDefinitionLoader)Mockito.spy((Object)super.createBeanDefinitionLoader(registry, sources));
            return this.loader;
        }

        public BeanDefinitionLoader getLoader() {
            return this.loader;
        }

        public void setShowBanner(boolean showBanner) {
            super.setShowBanner(showBanner);
            this.showBanner = showBanner;
        }

        public boolean getShowBanner() {
            return this.showBanner;
        }
    }

    public static class SpyApplicationContext
    extends AnnotationConfigApplicationContext {
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)Mockito.spy((Object)new AnnotationConfigApplicationContext());

        public void registerShutdownHook() {
            this.applicationContext.registerShutdownHook();
        }

        public ConfigurableApplicationContext getApplicationContext() {
            return this.applicationContext;
        }
    }
}

