/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.PropertyValues;
import org.springframework.boot.bind.PropertySourcesPropertyValues;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.validation.DataBinder;

public class PropertySourcesPropertyValuesTests {
    private MutablePropertySources propertySources = new MutablePropertySources();

    @Before
    public void init() {
        this.propertySources.addFirst((PropertySource)new PropertySource<String>("static", "foo"){

            public Object getProperty(String name) {
                if (name.equals(this.getSource())) {
                    return "bar";
                }
                return null;
            }
        });
        this.propertySources.addFirst((PropertySource)new MapPropertySource("map", Collections.singletonMap("name", "${foo}")));
    }

    @Test
    public void testSize() {
        PropertySourcesPropertyValues propertyValues = new PropertySourcesPropertyValues((PropertySources)this.propertySources);
        Assert.assertEquals((long)1L, (long)propertyValues.getPropertyValues().length);
    }

    @Test
    public void testNonEnumeratedValue() {
        PropertySourcesPropertyValues propertyValues = new PropertySourcesPropertyValues((PropertySources)this.propertySources);
        Assert.assertEquals((Object)"bar", (Object)propertyValues.getPropertyValue("foo").getValue());
    }

    @Test
    public void testEnumeratedValue() {
        PropertySourcesPropertyValues propertyValues = new PropertySourcesPropertyValues((PropertySources)this.propertySources);
        Assert.assertEquals((Object)"bar", (Object)propertyValues.getPropertyValue("name").getValue());
    }

    @Test
    public void testOverriddenValue() {
        this.propertySources.addFirst((PropertySource)new MapPropertySource("new", Collections.singletonMap("name", "spam")));
        PropertySourcesPropertyValues propertyValues = new PropertySourcesPropertyValues((PropertySources)this.propertySources);
        Assert.assertEquals((Object)"spam", (Object)propertyValues.getPropertyValue("name").getValue());
    }

    @Test
    public void testPlaceholdersBinding() {
        TestBean target = new TestBean();
        DataBinder binder = new DataBinder((Object)target);
        binder.bind((PropertyValues)new PropertySourcesPropertyValues((PropertySources)this.propertySources));
        Assert.assertEquals((Object)"bar", (Object)target.getName());
    }

    @Test
    public void testPlaceholdersBindingWithError() {
        TestBean target = new TestBean();
        DataBinder binder = new DataBinder((Object)target);
        this.propertySources.addFirst((PropertySource)new MapPropertySource("another", Collections.singletonMap("something", "${nonexistent}")));
        binder.bind((PropertyValues)new PropertySourcesPropertyValues((PropertySources)this.propertySources));
        Assert.assertEquals((Object)"bar", (Object)target.getName());
    }

    public static class TestBean {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

