/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.initializer;

import java.io.IOException;
import java.util.logging.LogManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.SLF4JLogFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.springframework.boot.OutputCapture;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.TestUtils;
import org.springframework.boot.context.initializer.LoggingApplicationContextInitializer;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.java.JavaLoggingSystem;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class LoggingApplicationContextInitializerTests {
    private static final String[] NO_ARGS = new String[0];
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public OutputCapture outputCapture = new OutputCapture();
    private LoggingApplicationContextInitializer initializer = new LoggingApplicationContextInitializer();
    private Log logger = new SLF4JLogFactory().getInstance(this.getClass());
    private SpringApplication springApplication = new SpringApplication(new Object[0]);
    private GenericApplicationContext context = new GenericApplicationContext();

    @Before
    public void init() throws SecurityException, IOException {
        LogManager.getLogManager().readConfiguration(JavaLoggingSystem.class.getResourceAsStream("logging.properties"));
        this.initializer.initialize(new SpringApplication(new Object[0]), NO_ARGS);
    }

    @After
    public void clear() {
        System.clearProperty("LOG_FILE");
        System.clearProperty("LOG_PATH");
        System.clearProperty("PID");
    }

    @Test
    public void testDefaultConfigLocation() {
        GenericApplicationContext context = new GenericApplicationContext();
        this.initializer.initialize((ConfigurableApplicationContext)context);
        this.logger.info((Object)"Hello world");
        String output = this.outputCapture.toString().trim();
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.contains("Hello world"));
        Assert.assertFalse((String)("Wrong output:\n" + output), (boolean)output.contains("???"));
    }

    @Test
    public void testOverrideConfigLocation() {
        TestUtils.addEnviroment((ConfigurableApplicationContext)this.context, "logging.config: classpath:logback-nondefault.xml");
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        this.logger.info((Object)"Hello world");
        String output = this.outputCapture.toString().trim();
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.contains("Hello world"));
        Assert.assertFalse((String)("Wrong output:\n" + output), (boolean)output.contains("???"));
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.startsWith("/tmp/spring.log"));
    }

    @Test
    public void testOverrideConfigDoesNotExist() throws Exception {
        TestUtils.addEnviroment((ConfigurableApplicationContext)this.context, "logging.config: doesnotexist.xml");
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
    }

    @Test
    public void testAddLogFileProperty() {
        TestUtils.addEnviroment((ConfigurableApplicationContext)this.context, "logging.config: classpath:logback-nondefault.xml", "logging.file: foo.log");
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        Log logger = LogFactory.getLog(LoggingApplicationContextInitializerTests.class);
        logger.info((Object)"Hello world");
        String output = this.outputCapture.toString().trim();
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.startsWith("foo.log"));
    }

    @Test
    public void testAddLogPathProperty() {
        TestUtils.addEnviroment((ConfigurableApplicationContext)this.context, "logging.config: classpath:logback-nondefault.xml", "logging.path: foo/");
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        Log logger = LogFactory.getLog(LoggingApplicationContextInitializerTests.class);
        logger.info((Object)"Hello world");
        String output = this.outputCapture.toString().trim();
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.startsWith("foo/spring.log"));
    }

    @Test
    public void parseDebugArg() throws Exception {
        this.initializer.initialize(this.springApplication, new String[]{"--debug"});
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        this.logger.debug((Object)"testatdebug");
        this.logger.trace((Object)"testattrace");
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.containsString((String)"testatdebug"));
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"testattrace")));
    }

    @Test
    public void parseTraceArg() throws Exception {
        this.context = new GenericApplicationContext();
        this.initializer.initialize(this.springApplication, new String[]{"--trace"});
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        this.logger.debug((Object)"testatdebug");
        this.logger.trace((Object)"testattrace");
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.containsString((String)"testatdebug"));
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.containsString((String)"testattrace"));
    }

    @Test
    public void parseArgsDisabled() throws Exception {
        this.initializer.setParseArgs(false);
        this.initializer.initialize(this.springApplication, new String[]{"--debug"});
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        this.logger.debug((Object)"testatdebug");
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"testatdebug")));
    }

    @Test
    public void parseArgsDoesntReplace() throws Exception {
        this.initializer.setSpringBootLogging(LogLevel.ERROR);
        this.initializer.setParseArgs(false);
        this.initializer.initialize(this.springApplication, new String[]{"--debug"});
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        this.logger.debug((Object)"testatdebug");
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"testatdebug")));
    }
}

