/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.java;

import java.io.IOException;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.boot.OutputCapture;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.java.JavaLoggingSystem;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class JavaLoggerSystemTests {
    private JavaLoggingSystem loggingSystem = new JavaLoggingSystem(this.getClass().getClassLoader());
    @Rule
    public OutputCapture output = new OutputCapture();
    private Jdk14Logger logger;

    @Before
    public void init() throws SecurityException, IOException {
        this.logger = new Jdk14Logger(this.getClass().getName());
    }

    @After
    public void clear() {
        System.clearProperty("LOG_FILE");
        System.clearProperty("LOG_PATH");
        System.clearProperty("PID");
    }

    @Test
    public void testCustomFormatter() throws Exception {
        this.loggingSystem.initialize();
        this.logger.info((Object)"Hello world");
        String output = this.output.toString().trim();
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.contains("Hello world"));
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.contains("???? INFO ["));
    }

    @Test
    public void testSystemPropertyInitializesFormat() throws Exception {
        System.setProperty("PID", "1234");
        this.loggingSystem.initialize("classpath:" + ClassUtils.addResourcePathToPackagePath(this.getClass(), (String)"logging.properties"));
        this.logger.info((Object)"Hello world");
        this.logger.info((Object)"Hello world");
        String output = this.output.toString().trim();
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.contains("Hello world"));
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.contains("1234 INFO ["));
    }

    @Test
    public void testNonDefaultConfigLocation() throws Exception {
        this.loggingSystem.initialize("classpath:logging-nondefault.properties");
        this.logger.info((Object)"Hello world");
        String output = this.output.toString().trim();
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.contains("INFO: Hello"));
    }

    @Test(expected=IllegalStateException.class)
    public void testNonexistentConfigLocation() throws Exception {
        this.loggingSystem.initialize("classpath:logging-nonexistent.properties");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullConfigLocation() throws Exception {
        this.loggingSystem.initialize(null);
    }

    @Test
    public void setLevel() throws Exception {
        this.loggingSystem.initialize();
        this.logger.debug((Object)"Hello");
        this.loggingSystem.setLogLevel("org.springframework.boot", LogLevel.DEBUG);
        this.logger.debug((Object)"Hello");
        Assert.assertThat((Object)StringUtils.countOccurrencesOf((String)this.output.toString(), (String)"Hello"), (Matcher)Matchers.equalTo((Object)1));
    }
}

