/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;

public class PropertySourcesPropertyValues
implements PropertyValues {
    private Map<String, PropertyValue> propertyValues = new ConcurrentHashMap<String, PropertyValue>();
    private PropertySources propertySources;

    public PropertySourcesPropertyValues(PropertySources propertySources) {
        this.propertySources = propertySources;
        PropertySourcesPropertyResolver resolver = new PropertySourcesPropertyResolver(propertySources);
        for (PropertySource source : propertySources) {
            EnumerablePropertySource enumerable;
            if (!(source instanceof EnumerablePropertySource) || (enumerable = (EnumerablePropertySource)source).getPropertyNames().length <= 0) continue;
            for (String propertyName : enumerable.getPropertyNames()) {
                Object value = source.getProperty(propertyName);
                try {
                    value = resolver.getProperty(propertyName);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
                this.propertyValues.put(propertyName, new PropertyValue(propertyName, value));
            }
        }
    }

    public PropertyValue[] getPropertyValues() {
        Collection<PropertyValue> values = this.propertyValues.values();
        return values.toArray(new PropertyValue[values.size()]);
    }

    public PropertyValue getPropertyValue(String propertyName) {
        PropertyValue propertyValue = this.propertyValues.get(propertyName);
        if (propertyValue != null) {
            return propertyValue;
        }
        for (PropertySource source : this.propertySources) {
            Object value = source.getProperty(propertyName);
            if (value == null) continue;
            propertyValue = new PropertyValue(propertyName, value);
            this.propertyValues.put(propertyName, propertyValue);
            return propertyValue;
        }
        return null;
    }

    public PropertyValues changesSince(PropertyValues old) {
        MutablePropertyValues changes = new MutablePropertyValues();
        for (PropertyValue newValue : this.getPropertyValues()) {
            PropertyValue oldValue = old.getPropertyValue(newValue.getName());
            if (oldValue != null && oldValue.equals((Object)newValue)) continue;
            changes.addPropertyValue(newValue);
        }
        return changes;
    }

    public boolean contains(String propertyName) {
        return this.getPropertyValue(propertyName) != null;
    }

    public boolean isEmpty() {
        return this.propertyValues.isEmpty();
    }
}

