/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationInitializer;
import org.springframework.boot.bind.PropertySourcesPropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.boot.config.PropertiesPropertySourceLoader;
import org.springframework.boot.config.PropertySourceLoader;
import org.springframework.boot.config.YamlPropertySourceLoader;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.Ordered;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ConfigFileApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
SpringApplicationInitializer,
Ordered,
EnvironmentAware {
    private static final String LOCATION_VARIABLE = "${spring.config.location}";
    private Environment environment;
    private String[] searchLocations = new String[]{"classpath:", "file:./", "classpath:config/", "file:./config/"};
    private String names = "${spring.config.name:application}";
    private int order = -2147483638;
    private Map<String, PropertySource<?>> cached = new HashMap();
    private ConversionService conversionService = new DefaultConversionService();

    @Override
    public void initialize(SpringApplication springApplication, String[] args) {
        if (this.environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment environment = (ConfigurableEnvironment)this.environment;
            this.load(environment, (ResourceLoader)new DefaultResourceLoader());
            PropertySourcesPropertyValues propertyValues = new PropertySourcesPropertyValues((PropertySources)environment.getPropertySources());
            RelaxedDataBinder binder = new RelaxedDataBinder(springApplication, "spring.main");
            binder.setConversionService(this.conversionService);
            binder.bind(propertyValues);
        }
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        this.load(applicationContext.getEnvironment(), (ResourceLoader)applicationContext);
    }

    private void load(ConfigurableEnvironment environment, ResourceLoader resourceLoader) {
        List<String> candidates = this.getCandidateLocations();
        Collections.reverse(candidates);
        PropertySource removed = environment.getPropertySources().remove("defaultProperties");
        ArrayList sources = new ArrayList();
        for (String string : candidates) {
            PropertySource<?> source = this.load(environment, resourceLoader, string, null);
            if (source == null) continue;
            sources.add(source);
        }
        for (String profile : environment.getActiveProfiles()) {
            for (String candidate : candidates) {
                PropertySource<?> source = this.load(environment, resourceLoader, candidate, profile);
                if (source == null) continue;
                environment.getPropertySources().addLast(source);
            }
        }
        for (PropertySource propertySource : sources) {
            environment.getPropertySources().addLast(propertySource);
        }
        if (removed != null) {
            environment.getPropertySources().addLast(removed);
        }
    }

    private List<String> getCandidateLocations() {
        ArrayList<String> candidates = new ArrayList<String>();
        for (String searchLocation : this.searchLocations) {
            for (String extension : new String[]{".properties", ".yml"}) {
                for (String name : StringUtils.commaDelimitedListToStringArray((String)this.names)) {
                    String location = searchLocation + name + extension;
                    candidates.add(location);
                }
            }
        }
        candidates.add(LOCATION_VARIABLE);
        return candidates;
    }

    private PropertySource<?> load(ConfigurableEnvironment environment, ResourceLoader resourceLoader, String location, String profile) {
        Resource resource;
        PropertySource<?> propertySource;
        location = environment.resolvePlaceholders(location);
        String suffix = "." + StringUtils.getFilenameExtension((String)location);
        if (StringUtils.hasLength((String)profile)) {
            location = location.replace(suffix, "-" + profile + suffix);
        }
        ArrayList<PropertySourceLoader> loaders = new ArrayList<PropertySourceLoader>();
        loaders.add(new PropertiesPropertySourceLoader());
        if (ClassUtils.isPresent((String)"org.yaml.snakeyaml.Yaml", null)) {
            loaders.add(YamlPropertySourceLoader.springProfileAwareLoader(environment.getActiveProfiles()));
        }
        if ((propertySource = this.getPropertySource(resource = resourceLoader.getResource(location), profile, loaders)) == null) {
            return null;
        }
        if (propertySource.containsProperty("spring.profiles.active")) {
            Set profiles = StringUtils.commaDelimitedListToSet((String)propertySource.getProperty("spring.profiles.active").toString());
            for (String active : profiles) {
                environment.addActiveProfile(active);
            }
        }
        return propertySource;
    }

    private PropertySource<?> getPropertySource(Resource resource, String profile, List<PropertySourceLoader> loaders) {
        String key = resource.getDescription() + (profile == null ? "" : "#" + profile);
        if (this.cached.containsKey(key)) {
            return this.cached.get(key);
        }
        for (PropertySourceLoader loader : loaders) {
            if (resource == null || !resource.exists() || !loader.supports(resource)) continue;
            PropertySource<?> propertySource = loader.load(resource);
            this.cached.put(key, propertySource);
            return propertySource;
        }
        return null;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setNames(String names) {
        this.names = names;
    }

    public void setSearchLocations(String[] searchLocations) {
        this.searchLocations = searchLocations == null ? null : (String[])searchLocations.clone();
    }
}

