/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.springframework.boot.config.DefaultProfileDocumentMatcher;
import org.springframework.boot.config.PropertiesPropertySourceLoader;
import org.springframework.boot.config.SpringProfileDocumentMatcher;
import org.springframework.boot.config.YamlProcessor;
import org.springframework.boot.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class YamlPropertySourceLoader
extends PropertiesPropertySourceLoader {
    private final List<YamlProcessor.DocumentMatcher> matchers;

    public YamlPropertySourceLoader(YamlProcessor.DocumentMatcher ... matchers) {
        this.matchers = Arrays.asList(matchers);
    }

    @Override
    public boolean supports(Resource resource) {
        return resource.getFilename().endsWith(".yml");
    }

    @Override
    protected Properties loadProperties(Resource resource) throws IOException {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        if (this.matchers != null && !this.matchers.isEmpty()) {
            factory.setMatchDefault(false);
            factory.setDocumentMatchers(this.matchers);
        }
        factory.setResources(new Resource[]{resource});
        return factory.getObject();
    }

    public static YamlPropertySourceLoader matchAllLoader() {
        return new YamlPropertySourceLoader(new YamlProcessor.DocumentMatcher[0]);
    }

    public static YamlPropertySourceLoader springProfileAwareLoader(String[] activeProfiles) {
        final SpringProfileDocumentMatcher matcher = new SpringProfileDocumentMatcher();
        for (String profile : activeProfiles) {
            matcher.addActiveProfiles(profile);
        }
        return new YamlPropertySourceLoader(matcher, new DefaultProfileDocumentMatcher(){

            @Override
            public YamlProcessor.MatchStatus matches(Properties properties) {
                YamlProcessor.MatchStatus result = super.matches(properties);
                if (result == YamlProcessor.MatchStatus.FOUND) {
                    Set profiles = StringUtils.commaDelimitedListToSet((String)properties.getProperty("spring.profiles.active", ""));
                    for (String profile : profiles) {
                        matcher.addActiveProfiles(profile);
                    }
                }
                return result;
            }
        });
    }
}

