/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.listener;

import java.net.URLClassLoader;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplicationErrorEvent;
import org.springframework.boot.SpringApplicationStartEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;

public final class ClasspathLoggingApplicationListener
implements SmartApplicationListener {
    private static final int ORDER = -2147483636;
    private final Log logger = LogFactory.getLog(this.getClass());

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof SpringApplicationStartEvent) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Application started with classpath: " + this.getClasspath()));
            }
        } else if (event instanceof SpringApplicationErrorEvent && this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Application failed to start with classpath: " + this.getClasspath()));
        }
    }

    public int getOrder() {
        return -2147483636;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> type) {
        return SpringApplicationStartEvent.class.isAssignableFrom(type) || SpringApplicationErrorEvent.class.isAssignableFrom(type);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    private String getClasspath() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof URLClassLoader) {
            return Arrays.toString(((URLClassLoader)classLoader).getURLs());
        }
        return "unknown";
    }
}

