/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.bind.PropertySourcesPropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.boot.context.config.RandomValuePropertySource;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.env.PropertySourcesLoader;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ConfigFileApplicationListener
implements ApplicationListener<ApplicationEvent>,
Ordered {
    private static final String DEFAULT_PROPERTIES = "defaultProperties";
    private static final String ACTIVE_PROFILES_PROPERTY = "spring.profiles.active";
    private static final String CONFIG_NAME_PROPERTY = "spring.config.name";
    private static final String CONFIG_LOCATION_PROPERTY = "spring.config.location";
    private static final String DEFAULT_SEARCH_LOCATIONS = "classpath:/,file:./,classpath:/config/,file:./config/";
    private static final String DEFAULT_NAMES = "application";
    public static final int DEFAULT_ORDER = -2147483638;
    private String searchLocations;
    private String names;
    private int order = -2147483638;
    private final ConversionService conversionService = new DefaultConversionService();

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            this.onApplicationEnvironmentPreparedEvent((ApplicationEnvironmentPreparedEvent)event);
        }
        if (event instanceof ApplicationPreparedEvent) {
            this.onApplicationPreparedEvent((ApplicationPreparedEvent)event);
        }
    }

    private void onApplicationEnvironmentPreparedEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        if (environment instanceof ConfigurableEnvironment) {
            this.onApplicationEnvironmentPreparedEvent(environment, event.getSpringApplication());
        }
    }

    private void onApplicationEnvironmentPreparedEvent(ConfigurableEnvironment environment, SpringApplication application) {
        this.addProperySources(environment);
        this.bindToSpringApplication(environment, application);
    }

    private void onApplicationPreparedEvent(ApplicationPreparedEvent event) {
        this.addPostProcessors(event.getApplicationContext());
    }

    protected void addProperySources(ConfigurableEnvironment environment) {
        RandomValuePropertySource.addToEnvironment(environment);
        try {
            PropertySource defaultProperties = environment.getPropertySources().remove(DEFAULT_PROPERTIES);
            new Loader(environment).load();
            if (defaultProperties != null) {
                environment.getPropertySources().addLast(defaultProperties);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load configuration files", ex);
        }
    }

    protected void bindToSpringApplication(ConfigurableEnvironment environment, SpringApplication application) {
        RelaxedDataBinder binder = new RelaxedDataBinder(application, "spring.main");
        binder.setConversionService(this.conversionService);
        binder.bind(new PropertySourcesPropertyValues((PropertySources)environment.getPropertySources()));
    }

    protected void addPostProcessors(ConfigurableApplicationContext context) {
        context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new PropertySourceOrderingPostProcessor(context));
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setSearchLocations(String locations) {
        Assert.hasLength((String)locations, (String)"Locations must not be empty");
        this.searchLocations = locations;
    }

    public void setSearchNames(String names) {
        Assert.hasLength((String)names, (String)"Names must not be empty");
        this.names = names;
    }

    static class ConfigurationPropertySources
    extends EnumerablePropertySource<Collection<PropertySource<?>>> {
        private static final String NAME = "applicationConfigurationProperties";
        private final Collection<PropertySource<?>> sources;
        private final String[] names;

        public ConfigurationPropertySources(Collection<PropertySource<?>> sources) {
            super(NAME, sources);
            this.sources = sources;
            ArrayList<String> names = new ArrayList<String>();
            for (PropertySource<?> source : sources) {
                if (!(source instanceof EnumerablePropertySource)) continue;
                names.addAll(Arrays.asList(((EnumerablePropertySource)source).getPropertyNames()));
            }
            this.names = names.toArray(new String[names.size()]);
        }

        public Object getProperty(String name) {
            for (PropertySource<?> propertySource : this.sources) {
                Object value = propertySource.getProperty(name);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        public static void finishAndRelocate(MutablePropertySources propertySources) {
            ConfigurationPropertySources removed = (ConfigurationPropertySources)propertySources.remove(NAME);
            if (removed != null) {
                for (PropertySource<?> propertySource : removed.sources) {
                    propertySources.addLast(propertySource);
                }
            }
        }

        public String[] getPropertyNames() {
            return this.names;
        }
    }

    private class Loader {
        private final ConfigurableEnvironment environment;
        private final ResourceLoader resourceLoader = new DefaultResourceLoader();
        private PropertySourcesLoader propertiesLoader;
        private Queue<String> profiles;
        private boolean activatedProfiles;

        public Loader(ConfigurableEnvironment environment) {
            this.environment = environment;
        }

        public void load() throws IOException {
            this.propertiesLoader = new PropertySourcesLoader();
            this.profiles = new LinkedList<String>();
            this.profiles.add(null);
            this.profiles.addAll(Arrays.asList(this.environment.getActiveProfiles()));
            this.activatedProfiles = false;
            this.addActiveProfiles(this.environment.getProperty(ConfigFileApplicationListener.ACTIVE_PROFILES_PROPERTY));
            while (!this.profiles.isEmpty()) {
                String profile = this.profiles.poll();
                for (String location : this.getSearchLocations()) {
                    for (String name : this.getSearchNames()) {
                        this.load(location, name, profile);
                    }
                }
            }
            this.addConfigurationProperties(this.propertiesLoader.getPropertySources());
        }

        private void load(String location, String name, String profile) throws IOException {
            PropertySource<?> locationPropertySource = this.load(location, profile);
            if (locationPropertySource == null) {
                for (String ext : this.propertiesLoader.getAllFileExtensions()) {
                    if (profile != null) {
                        this.load(location + name + "-" + profile + "." + ext, null);
                        this.load(location + name + "-" + profile + "." + ext, profile);
                    }
                    this.load(location + name + "." + ext, profile);
                }
            }
        }

        private PropertySource<?> load(String resourceLocation, String profile) throws IOException {
            Resource resource = this.resourceLoader.getResource(resourceLocation);
            if (resource != null && resource.exists()) {
                PropertySource<?> propertySource;
                String name = "applicationConfig: " + resource.getDescription();
                if (StringUtils.hasLength((String)profile)) {
                    name = name + " " + profile;
                }
                if ((propertySource = this.propertiesLoader.load(resource, name, profile)) != null) {
                    this.addActiveProfiles(propertySource.getProperty(ConfigFileApplicationListener.ACTIVE_PROFILES_PROPERTY));
                }
                return propertySource;
            }
            return null;
        }

        private void addActiveProfiles(Object property) {
            String profiles = property == null ? null : property.toString();
            boolean profilesNotActivatedWhenCalled = !this.activatedProfiles;
            for (String profile : this.asResolvedSet(profiles, null)) {
                boolean addition = profile.startsWith("+");
                String string = profile = addition ? profile.substring(1) : profile;
                if (!profilesNotActivatedWhenCalled && !addition) continue;
                this.profiles.add(profile);
                this.environment.addActiveProfile(profile);
                this.activatedProfiles = true;
            }
        }

        public Set<String> getSearchLocations() {
            LinkedHashSet<String> locations = new LinkedHashSet<String>();
            locations.addAll(this.asResolvedSet(ConfigFileApplicationListener.this.searchLocations, ConfigFileApplicationListener.DEFAULT_SEARCH_LOCATIONS));
            if (this.environment.containsProperty(ConfigFileApplicationListener.CONFIG_LOCATION_PROPERTY)) {
                for (String path : this.asResolvedSet(this.environment.getProperty(ConfigFileApplicationListener.CONFIG_LOCATION_PROPERTY), null)) {
                    if (!path.contains("$")) {
                        if (!path.contains(":")) {
                            path = "file:" + path;
                        }
                        path = StringUtils.cleanPath((String)path);
                    }
                    locations.add(path);
                }
            }
            return locations;
        }

        public Set<String> getSearchNames() {
            if (this.environment.containsProperty(ConfigFileApplicationListener.CONFIG_NAME_PROPERTY)) {
                return this.asResolvedSet(this.environment.getProperty(ConfigFileApplicationListener.CONFIG_NAME_PROPERTY), null);
            }
            return this.asResolvedSet(ConfigFileApplicationListener.this.names, ConfigFileApplicationListener.DEFAULT_NAMES);
        }

        private Set<String> asResolvedSet(String value, String fallback) {
            List<String> list = Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)(value != null ? this.environment.resolvePlaceholders(value) : fallback)));
            Collections.reverse(list);
            return new LinkedHashSet<String>(list);
        }

        private void addConfigurationProperties(MutablePropertySources sources) {
            ArrayList reorderedSources = new ArrayList();
            for (PropertySource item : sources) {
                reorderedSources.add(item);
            }
            Collections.reverse(reorderedSources);
            this.environment.getPropertySources().addLast((PropertySource)new ConfigurationPropertySources(reorderedSources));
        }
    }

    private class PropertySourceOrderingPostProcessor
    implements BeanFactoryPostProcessor,
    Ordered {
        private ConfigurableApplicationContext context;

        public PropertySourceOrderingPostProcessor(ConfigurableApplicationContext context) {
            this.context = context;
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            this.reorderSources(this.context.getEnvironment());
        }

        private void reorderSources(ConfigurableEnvironment environment) {
            ConfigurationPropertySources.finishAndRelocate(environment.getPropertySources());
            PropertySource defaultProperties = environment.getPropertySources().remove(ConfigFileApplicationListener.DEFAULT_PROPERTIES);
            if (defaultProperties != null) {
                environment.getPropertySources().addLast(defaultProperties);
            }
        }
    }
}

