/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import org.springframework.http.HttpStatus;
import org.springframework.util.ObjectUtils;

public class ErrorPage {
    private final String path;
    private Class<? extends Throwable> exception = null;
    private HttpStatus status = null;

    public ErrorPage(String path) {
        this.path = path;
    }

    public ErrorPage(HttpStatus status, String path) {
        this.status = status;
        this.path = path;
    }

    public ErrorPage(Class<? extends Throwable> exception, String path) {
        this.exception = exception;
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public Class<? extends Throwable> getException() {
        return this.exception;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public int getStatusCode() {
        return this.status == null ? 0 : this.status.value();
    }

    public String getExceptionName() {
        return this.exception == null ? null : this.exception.getName();
    }

    public boolean isGlobal() {
        return this.status == null && this.exception == null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.getExceptionName());
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.path);
        result = 31 * result + this.getStatusCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorPage other = (ErrorPage)obj;
        boolean rtn = true;
        rtn &= ObjectUtils.nullSafeEquals((Object)this.getExceptionName(), (Object)other.getExceptionName());
        rtn &= ObjectUtils.nullSafeEquals((Object)this.path, (Object)other.path);
        return rtn &= this.status == other.status;
    }
}

