/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.bind.RelaxedNames;

public class RelaxedNamesTests {
    @Test
    public void iterator() throws Exception {
        Iterator iterator = new RelaxedNames("my-RELAXED-property").iterator();
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"my-RELAXED-property"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"my_RELAXED_property"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"myRELAXEDProperty"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"my-relaxed-property"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"my_relaxed_property"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"myrelaxedproperty"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"MY-RELAXED-PROPERTY"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"MY_RELAXED_PROPERTY"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"MYRELAXEDPROPERTY"));
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void fromUnderscores() throws Exception {
        Iterator iterator = new RelaxedNames("nes_ted").iterator();
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"nes_ted"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"nes.ted"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"nesTed"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"nested"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"NES_TED"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"NES.TED"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"NESTED"));
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void fromPlain() throws Exception {
        Iterator iterator = new RelaxedNames("plain").iterator();
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"plain"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"PLAIN"));
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void fromCamelCase() throws Exception {
        Iterator iterator = new RelaxedNames("caMel").iterator();
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"caMel"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"ca_mel"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"camel"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"CAMEL"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"CA_MEL"));
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void fromPeriods() throws Exception {
        Iterator iterator = new RelaxedNames("spring.value").iterator();
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"spring.value"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"spring_value"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"springValue"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"springvalue"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"SPRING.VALUE"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"SPRING_VALUE"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"SPRINGVALUE"));
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void fromPrefixEndingInPeriod() throws Exception {
        Iterator iterator = new RelaxedNames("spring.").iterator();
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"spring."));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"spring_"));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"SPRING."));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)"SPRING_"));
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void fromEmpty() throws Exception {
        Iterator iterator = new RelaxedNames("").iterator();
        Assert.assertThat(iterator.next(), (Matcher)Matchers.equalTo((Object)""));
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.equalTo((Object)false));
    }
}

