/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.springframework.boot.context.config.DelegatingApplicationContextInitializer;
import org.springframework.boot.test.EnvironmentTestUtils;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public class DelegatingApplicationContextInitializerTests {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final DelegatingApplicationContextInitializer initializer = new DelegatingApplicationContextInitializer();

    @Test
    public void orderedInitialize() throws Exception {
        StaticApplicationContext context = new StaticApplicationContext();
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)context, (String[])new String[]{"context.initializer.classes:" + MockInitB.class.getName() + "," + MockInitA.class.getName()});
        this.initializer.initialize((ConfigurableApplicationContext)context);
        Assert.assertThat((Object)context.getBeanFactory().getSingleton("a"), (Matcher)Matchers.equalTo((Object)"a"));
        Assert.assertThat((Object)context.getBeanFactory().getSingleton("b"), (Matcher)Matchers.equalTo((Object)"b"));
    }

    @Test
    public void noInitializers() throws Exception {
        StaticApplicationContext context = new StaticApplicationContext();
        this.initializer.initialize((ConfigurableApplicationContext)context);
    }

    @Test
    public void emptyInitializers() throws Exception {
        StaticApplicationContext context = new StaticApplicationContext();
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)context, (String[])new String[]{"context.initializer.classes:"});
        this.initializer.initialize((ConfigurableApplicationContext)context);
    }

    @Test
    public void noSuchInitializerClass() throws Exception {
        StaticApplicationContext context = new StaticApplicationContext();
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)context, (String[])new String[]{"context.initializer.classes:missing.madeup.class"});
        this.thrown.expect(ApplicationContextException.class);
        this.initializer.initialize((ConfigurableApplicationContext)context);
    }

    @Test
    public void notAnInitializerClass() throws Exception {
        StaticApplicationContext context = new StaticApplicationContext();
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)context, (String[])new String[]{"context.initializer.classes:" + Object.class.getName()});
        this.thrown.expect(IllegalArgumentException.class);
        this.initializer.initialize((ConfigurableApplicationContext)context);
    }

    @Test
    public void genericNotSuitable() throws Exception {
        StaticApplicationContext context = new StaticApplicationContext();
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)context, (String[])new String[]{"context.initializer.classes:" + NotSuitableInit.class.getName()});
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("generic parameter");
        this.initializer.initialize((ConfigurableApplicationContext)context);
    }

    private static class NotSuitableInit
    implements ApplicationContextInitializer<ConfigurableWebApplicationContext> {
        private NotSuitableInit() {
        }

        public void initialize(ConfigurableWebApplicationContext applicationContext) {
        }
    }

    @Order(value=0x7FFFFFFF)
    private static class MockInitB
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private MockInitB() {
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            Assert.assertThat((Object)applicationContext.getBeanFactory().getSingleton("a"), (Matcher)Matchers.equalTo((Object)"a"));
            applicationContext.getBeanFactory().registerSingleton("b", (Object)"b");
        }
    }

    @Order(value=-2147483648)
    private static class MockInitA
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private MockInitA() {
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            applicationContext.getBeanFactory().registerSingleton("a", (Object)"a");
        }
    }
}

