/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.context.config.RandomValuePropertySource;

public class RandomValuePropertySourceTests {
    private RandomValuePropertySource source = new RandomValuePropertySource("random");

    @Test
    public void notRandom() {
        Assert.assertNull((Object)this.source.getProperty("foo"));
    }

    @Test
    public void string() {
        Assert.assertNotNull((Object)this.source.getProperty("random.string"));
    }

    @Test
    public void intValue() {
        Integer value = (Integer)this.source.getProperty("random.int");
        Assert.assertNotNull((Object)value);
    }

    @Test
    public void intRange() {
        Integer value = (Integer)this.source.getProperty("random.int[4,10]");
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((value >= 4 ? 1 : 0) != 0);
    }

    @Test
    public void intMax() {
        Integer value = (Integer)this.source.getProperty("random.int(10)");
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((value < 10 ? 1 : 0) != 0);
    }

    @Test
    public void longValue() {
        Long value = (Long)this.source.getProperty("random.long");
        Assert.assertNotNull((Object)value);
    }
}

