/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.startup.Tomcat;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.BDDMockito;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.boot.context.embedded.MimeMappings;

public class MimeMappingsTests {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void defaults() throws Exception {
        Assert.assertThat((Object)MimeMappings.DEFAULT, (Matcher)org.hamcrest.Matchers.equalTo((Object)this.getTomatDefaults()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void defaultsCannotBeModified() throws Exception {
        MimeMappings.DEFAULT.add("foo", "foo/bar");
    }

    @Test
    public void createFromExisting() throws Exception {
        MimeMappings mappings = new MimeMappings();
        mappings.add("foo", "bar");
        MimeMappings clone = new MimeMappings(mappings);
        mappings.add("baz", "bar");
        Assert.assertThat((Object)clone.get("foo"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"bar"));
        Assert.assertThat((Object)clone.get("baz"), (Matcher)org.hamcrest.Matchers.nullValue());
    }

    @Test
    public void createFromMap() throws Exception {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("foo", "bar");
        MimeMappings clone = new MimeMappings(mappings);
        mappings.put("baz", "bar");
        Assert.assertThat((Object)clone.get("foo"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"bar"));
        Assert.assertThat((Object)clone.get("baz"), (Matcher)org.hamcrest.Matchers.nullValue());
    }

    @Test
    public void iterate() throws Exception {
        MimeMappings mappings = new MimeMappings();
        mappings.add("foo", "bar");
        mappings.add("baz", "boo");
        ArrayList<MimeMappings.Mapping> mappingList = new ArrayList<MimeMappings.Mapping>();
        for (MimeMappings.Mapping mapping : mappings) {
            mappingList.add(mapping);
        }
        Assert.assertThat((Object)((MimeMappings.Mapping)mappingList.get(0)).getExtension(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"foo"));
        Assert.assertThat((Object)((MimeMappings.Mapping)mappingList.get(0)).getMimeType(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"bar"));
        Assert.assertThat((Object)((MimeMappings.Mapping)mappingList.get(1)).getExtension(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"baz"));
        Assert.assertThat((Object)((MimeMappings.Mapping)mappingList.get(1)).getMimeType(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"boo"));
    }

    @Test
    public void getAll() throws Exception {
        MimeMappings mappings = new MimeMappings();
        mappings.add("foo", "bar");
        mappings.add("baz", "boo");
        ArrayList mappingList = new ArrayList();
        mappingList.addAll(mappings.getAll());
        Assert.assertThat((Object)((MimeMappings.Mapping)mappingList.get(0)).getExtension(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"foo"));
        Assert.assertThat((Object)((MimeMappings.Mapping)mappingList.get(0)).getMimeType(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"bar"));
        Assert.assertThat((Object)((MimeMappings.Mapping)mappingList.get(1)).getExtension(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"baz"));
        Assert.assertThat((Object)((MimeMappings.Mapping)mappingList.get(1)).getMimeType(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"boo"));
    }

    @Test
    public void addNew() throws Exception {
        MimeMappings mappings = new MimeMappings();
        Assert.assertThat((Object)mappings.add("foo", "bar"), (Matcher)org.hamcrest.Matchers.nullValue());
    }

    @Test
    public void addReplacesExisting() throws Exception {
        MimeMappings mappings = new MimeMappings();
        mappings.add("foo", "bar");
        Assert.assertThat((Object)mappings.add("foo", "baz"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"bar"));
    }

    @Test
    public void remove() throws Exception {
        MimeMappings mappings = new MimeMappings();
        mappings.add("foo", "bar");
        Assert.assertThat((Object)mappings.remove("foo"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"bar"));
        Assert.assertThat((Object)mappings.remove("foo"), (Matcher)org.hamcrest.Matchers.nullValue());
    }

    @Test
    public void get() throws Exception {
        MimeMappings mappings = new MimeMappings();
        mappings.add("foo", "bar");
        Assert.assertThat((Object)mappings.get("foo"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"bar"));
    }

    @Test
    public void getMissing() throws Exception {
        MimeMappings mappings = new MimeMappings();
        Assert.assertThat((Object)mappings.get("foo"), (Matcher)org.hamcrest.Matchers.nullValue());
    }

    @Test
    public void makeUnmodifiable() throws Exception {
        MimeMappings mappings = new MimeMappings();
        mappings.add("foo", "bar");
        MimeMappings unmodifiable = MimeMappings.unmodifiableMappings((MimeMappings)mappings);
        try {
            unmodifiable.remove("foo");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        mappings.remove("foo");
        Assert.assertThat((Object)unmodifiable.get("foo"), (Matcher)org.hamcrest.Matchers.nullValue());
    }

    private MimeMappings getTomatDefaults() {
        final MimeMappings mappings = new MimeMappings();
        Context ctx = (Context)Mockito.mock(Context.class);
        Wrapper wrapper = (Wrapper)Mockito.mock(Wrapper.class);
        BDDMockito.given((Object)ctx.createWrapper()).willReturn((Object)wrapper);
        ((Context)BDDMockito.willAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                mappings.add((String)args[0], (String)args[1]);
                return null;
            }
        }).given((Object)ctx)).addMimeMapping(Matchers.anyString(), Matchers.anyString());
        Tomcat.initWebappDefaults((Context)ctx);
        return mappings;
    }
}

