/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.EnvironmentTestUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.mock.env.MockEnvironment;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class ConfigurationPropertiesBindingPostProcessorTests {
    private AnnotationConfigApplicationContext context;

    @After
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    @Test
    public void testValidationWithSetter() {
        this.context = new AnnotationConfigApplicationContext();
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"test.foo:spam"});
        this.context.register(new Class[]{TestConfigurationWithValidatingSetter.class});
        try {
            this.context.refresh();
            Assert.fail((String)"Expected exception");
        }
        catch (BeanCreationException ex) {
            BindException bex = (BindException)ex.getRootCause();
            Assert.assertTrue((1 == bex.getErrorCount() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testValidationWithoutJSR303() {
        this.context = new AnnotationConfigApplicationContext();
        this.context.register(new Class[]{TestConfigurationWithoutJSR303.class});
        try {
            this.context.refresh();
            Assert.fail((String)"Expected exception");
        }
        catch (BeanCreationException ex) {
            BindException bex = (BindException)ex.getRootCause();
            Assert.assertTrue((1 == bex.getErrorCount() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testValidationWithJSR303() {
        this.context = new AnnotationConfigApplicationContext();
        this.context.register(new Class[]{TestConfigurationWithJSR303.class});
        try {
            this.context.refresh();
            Assert.fail((String)"Expected exception");
        }
        catch (BeanCreationException ex) {
            BindException bex = (BindException)ex.getRootCause();
            Assert.assertTrue((2 == bex.getErrorCount() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSuccessfulValidationWithJSR303() {
        MockEnvironment env = new MockEnvironment();
        env.setProperty("test.foo", "123456");
        env.setProperty("test.bar", "654321");
        this.context = new AnnotationConfigApplicationContext();
        this.context.setEnvironment((ConfigurableEnvironment)env);
        this.context.register(new Class[]{TestConfigurationWithJSR303.class});
        this.context.refresh();
    }

    @Test
    public void testInitializersSeeBoundProperties() {
        MockEnvironment env = new MockEnvironment();
        env.setProperty("bar", "foo");
        this.context = new AnnotationConfigApplicationContext();
        this.context.setEnvironment((ConfigurableEnvironment)env);
        this.context.register(new Class[]{TestConfigurationWithInitializer.class});
        this.context.refresh();
    }

    @ConfigurationProperties(prefix="test")
    public static class PropertyWithJSR303
    extends PropertyWithoutJSR303 {
        @NotNull
        private String bar;

        public void setBar(String bar) {
            this.bar = bar;
        }

        public String getBar() {
            return this.bar;
        }
    }

    @Configuration
    @EnableConfigurationProperties
    @ConfigurationProperties
    public static class TestConfigurationWithInitializer {
        private String bar;

        public void setBar(String bar) {
            this.bar = bar;
        }

        public String getBar() {
            return this.bar;
        }

        @PostConstruct
        public void init() {
            Assert.assertNotNull((Object)this.bar);
        }
    }

    @Configuration
    @EnableConfigurationProperties
    public static class TestConfigurationWithJSR303 {
        @Bean
        public PropertyWithJSR303 testProperties() {
            return new PropertyWithJSR303();
        }
    }

    @ConfigurationProperties(prefix="test")
    public static class PropertyWithoutJSR303
    implements Validator {
        private String foo;

        public boolean supports(Class<?> clazz) {
            return clazz.isAssignableFrom(this.getClass());
        }

        public void validate(Object target, Errors errors) {
            ValidationUtils.rejectIfEmpty((Errors)errors, (String)"foo", (String)"TEST1");
        }

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }
    }

    @Configuration
    @EnableConfigurationProperties
    public static class TestConfigurationWithoutJSR303 {
        @Bean
        public PropertyWithoutJSR303 testProperties() {
            return new PropertyWithoutJSR303();
        }
    }

    @ConfigurationProperties(prefix="test")
    public static class PropertyWithValidatingSetter {
        private String foo;

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
            if (!foo.equals("bar")) {
                throw new IllegalArgumentException("Wrong value for foo");
            }
        }
    }

    @Configuration
    @EnableConfigurationProperties
    public static class TestConfigurationWithValidatingSetter {
        @Bean
        public PropertyWithValidatingSetter testProperties() {
            return new PropertyWithValidatingSetter();
        }
    }
}

