/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.orm.jpa;

import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.springframework.boot.orm.jpa.EntityScan;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

public class EntityScanTests {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private AnnotationConfigApplicationContext context;

    @Test
    public void testValue() throws Exception {
        this.context = new AnnotationConfigApplicationContext(new Class[]{ValueConfig.class});
        this.assertSetPackagesToScan("com.mycorp.entity");
    }

    @Test
    public void basePackages() throws Exception {
        this.context = new AnnotationConfigApplicationContext(new Class[]{BasePackagesConfig.class});
        this.assertSetPackagesToScan("com.mycorp.entity2");
    }

    @Test
    public void basePackageClasses() throws Exception {
        this.context = new AnnotationConfigApplicationContext(new Class[]{BasePackageClassesConfig.class});
        this.assertSetPackagesToScan(this.getClass().getPackage().getName());
    }

    @Test
    public void fromConfigurationClass() throws Exception {
        this.context = new AnnotationConfigApplicationContext(new Class[]{FromConfigConfig.class});
        this.assertSetPackagesToScan(this.getClass().getPackage().getName());
    }

    @Test
    public void valueAndBasePackagesThrows() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("@EntityScan basePackages and value attributes are mutually exclusive");
        this.context = new AnnotationConfigApplicationContext(new Class[]{ValueAndBasePackages.class});
    }

    @Test
    public void valueAndBasePackageClassesMerges() throws Exception {
        this.context = new AnnotationConfigApplicationContext(new Class[]{ValueAndBasePackageClasses.class});
        this.assertSetPackagesToScan("com.mycorp.entity", this.getClass().getPackage().getName());
    }

    @Test
    public void basePackageAndBasePackageClassesMerges() throws Exception {
        this.context = new AnnotationConfigApplicationContext(new Class[]{BasePackagesAndBasePackageClasses.class});
        this.assertSetPackagesToScan("com.mycorp.entity2", this.getClass().getPackage().getName());
    }

    @Test
    public void needsEntityManageFactory() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Unable to configure LocalContainerEntityManagerFactoryBean from @EntityScan, ensure an appropriate bean is registered.");
        this.context = new AnnotationConfigApplicationContext(new Class[]{MissingEntityManager.class});
    }

    private void assertSetPackagesToScan(String ... expected) {
        String[] actual = ((TestLocalContainerEntityManagerFactoryBean)((Object)this.context.getBean(TestLocalContainerEntityManagerFactoryBean.class))).getPackagesToScan();
        Assert.assertThat((Object)actual, (Matcher)Matchers.equalTo((Object)expected));
    }

    private static class TestLocalContainerEntityManagerFactoryBean
    extends LocalContainerEntityManagerFactoryBean {
        private String[] packagesToScan;

        private TestLocalContainerEntityManagerFactoryBean() {
        }

        protected EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException {
            return (EntityManagerFactory)Mockito.mock(EntityManagerFactory.class);
        }

        public void setPackagesToScan(String ... packagesToScan) {
            this.packagesToScan = packagesToScan;
        }

        public String[] getPackagesToScan() {
            return this.packagesToScan;
        }
    }

    @Configuration
    @EntityScan(value={"com.mycorp.entity"})
    static class MissingEntityManager {
        MissingEntityManager() {
        }
    }

    @EntityScan(basePackages={"com.mycorp.entity2"}, basePackageClasses={EntityScanTests.class})
    static class BasePackagesAndBasePackageClasses
    extends BaseConfig {
        BasePackagesAndBasePackageClasses() {
        }
    }

    @EntityScan(value={"com.mycorp.entity"}, basePackageClasses={EntityScanTests.class})
    static class ValueAndBasePackageClasses
    extends BaseConfig {
        ValueAndBasePackageClasses() {
        }
    }

    @EntityScan(value={"com.mycorp.entity"}, basePackages={"com.mycorp"})
    static class ValueAndBasePackages
    extends BaseConfig {
        ValueAndBasePackages() {
        }
    }

    @EntityScan
    static class FromConfigConfig
    extends BaseConfig {
        FromConfigConfig() {
        }
    }

    @EntityScan(basePackageClasses={EntityScanTests.class})
    static class BasePackageClassesConfig
    extends BaseConfig {
        BasePackageClassesConfig() {
        }
    }

    @EntityScan(basePackages={"com.mycorp.entity2"})
    static class BasePackagesConfig
    extends BaseConfig {
        BasePackagesConfig() {
        }
    }

    @EntityScan(value={"com.mycorp.entity"})
    static class ValueConfig
    extends BaseConfig {
        ValueConfig() {
        }
    }

    @Configuration
    static class BaseConfig {
        BaseConfig() {
        }

        @Bean
        public TestLocalContainerEntityManagerFactoryBean entityManagerFactoryBean() {
            return new TestLocalContainerEntityManagerFactoryBean();
        }
    }
}

