/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.util.Collection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.ServletContextInitializerBeans;
import org.springframework.boot.context.embedded.WebApplicationContextServletContextAwareProcessor;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class EmbeddedWebApplicationContext
extends GenericWebApplicationContext {
    public static final String DISPATCHER_SERVLET_NAME = "dispatcherServlet";
    private EmbeddedServletContainer embeddedServletContainer;
    private ServletConfig servletConfig;
    private String namespace;

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new WebApplicationContextServletContextAwareProcessor((ConfigurableWebApplicationContext)this));
        beanFactory.ignoreDependencyInterface(ServletContextAware.class);
    }

    public final void refresh() throws BeansException, IllegalStateException {
        try {
            super.refresh();
        }
        catch (RuntimeException ex) {
            this.stopAndReleaseEmbeddedServletContainer();
            throw ex;
        }
    }

    protected void onRefresh() {
        super.onRefresh();
        try {
            this.createEmbeddedServletContainer();
        }
        catch (Throwable ex) {
            throw new ApplicationContextException("Unable to start embedded container", ex);
        }
    }

    protected void finishRefresh() {
        super.finishRefresh();
        this.startEmbeddedServletContainer();
        if (this.embeddedServletContainer != null) {
            this.publishEvent(new EmbeddedServletContainerInitializedEvent(this, this.embeddedServletContainer));
        }
    }

    protected void doClose() {
        super.doClose();
        this.stopAndReleaseEmbeddedServletContainer();
    }

    private synchronized void createEmbeddedServletContainer() {
        if (this.embeddedServletContainer == null && this.getServletContext() == null) {
            EmbeddedServletContainerFactory containerFactory = this.getEmbeddedServletContainerFactory();
            this.embeddedServletContainer = containerFactory.getEmbeddedServletContainer(this.getSelfInitializer());
        } else if (this.getServletContext() != null) {
            try {
                this.getSelfInitializer().onStartup(this.getServletContext());
            }
            catch (ServletException ex) {
                throw new ApplicationContextException("Cannot initialize servlet context", (Throwable)ex);
            }
        }
        this.initPropertySources();
    }

    protected EmbeddedServletContainerFactory getEmbeddedServletContainerFactory() {
        Object[] beanNames = this.getBeanFactory().getBeanNamesForType(EmbeddedServletContainerFactory.class);
        if (beanNames.length == 0) {
            throw new ApplicationContextException("Unable to start EmbeddedWebApplicationContext due to missing EmbeddedServletContainerFactory bean.");
        }
        if (beanNames.length > 1) {
            throw new ApplicationContextException("Unable to start EmbeddedWebApplicationContext due to multiple EmbeddedServletContainerFactory beans : " + StringUtils.arrayToCommaDelimitedString((Object[])beanNames));
        }
        return (EmbeddedServletContainerFactory)this.getBeanFactory().getBean(beanNames[0], EmbeddedServletContainerFactory.class);
    }

    private ServletContextInitializer getSelfInitializer() {
        return new ServletContextInitializer(){

            @Override
            public void onStartup(ServletContext servletContext) throws ServletException {
                EmbeddedWebApplicationContext.this.prepareEmbeddedWebApplicationContext(servletContext);
                WebApplicationContextUtils.registerWebApplicationScopes((ConfigurableListableBeanFactory)EmbeddedWebApplicationContext.this.getBeanFactory(), (ServletContext)EmbeddedWebApplicationContext.this.getServletContext());
                WebApplicationContextUtils.registerEnvironmentBeans((ConfigurableListableBeanFactory)EmbeddedWebApplicationContext.this.getBeanFactory(), (ServletContext)EmbeddedWebApplicationContext.this.getServletContext());
                for (ServletContextInitializer beans : EmbeddedWebApplicationContext.this.getServletContextInitializerBeans()) {
                    beans.onStartup(servletContext);
                }
            }
        };
    }

    protected Collection<ServletContextInitializer> getServletContextInitializerBeans() {
        return new ServletContextInitializerBeans((ListableBeanFactory)this.getBeanFactory());
    }

    protected void prepareEmbeddedWebApplicationContext(ServletContext servletContext) {
        Object rootContext = servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (rootContext != null) {
            if (rootContext == this) {
                throw new IllegalStateException("Cannot initialize context because there is already a root application context present - check whether you have multiple ServletContextInitializers!");
            }
            return;
        }
        Log logger = LogFactory.getLog(ContextLoader.class);
        servletContext.log("Initializing Spring embedded WebApplicationContext");
        try {
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Published root WebApplicationContext as ServletContext attribute with name [" + WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE + "]"));
            }
            this.setServletContext(servletContext);
            if (logger.isInfoEnabled()) {
                long elapsedTime = System.currentTimeMillis() - this.getStartupDate();
                logger.info((Object)("Root WebApplicationContext: initialization completed in " + elapsedTime + " ms"));
            }
        }
        catch (RuntimeException ex) {
            logger.error((Object)"Context initialization failed", (Throwable)ex);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)ex);
            throw ex;
        }
        catch (Error ex) {
            logger.error((Object)"Context initialization failed", (Throwable)ex);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)ex);
            throw ex;
        }
    }

    private void startEmbeddedServletContainer() {
        if (this.embeddedServletContainer != null) {
            this.embeddedServletContainer.start();
        }
    }

    private synchronized void stopAndReleaseEmbeddedServletContainer() {
        if (this.embeddedServletContainer != null) {
            try {
                this.embeddedServletContainer.stop();
                this.embeddedServletContainer = null;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    protected Resource getResourceByPath(String path) {
        if (this.getServletContext() == null) {
            return new DefaultResourceLoader.ClassPathContextResource(path, this.getClassLoader());
        }
        return new ServletContextResource(this.getServletContext(), path);
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public EmbeddedServletContainer getEmbeddedServletContainer() {
        return this.embeddedServletContainer;
    }
}

