/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.admin;

import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.admin.SpringApplicationAdminMXBeanRegistrar;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

public class SpringApplicationAdminMXBeanRegistrarTests {
    private static final String OBJECT_NAME = "org.springframework.boot:type=Test,name=SpringApplication";
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private MBeanServer mBeanServer;
    private ConfigurableApplicationContext context;

    @Before
    public void setup() throws MalformedObjectNameException {
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    @After
    public void closeContext() {
        if (this.context != null) {
            this.context.close();
        }
    }

    @Test
    public void validateReadyFlag() {
        final ObjectName objectName = this.createObjectName(OBJECT_NAME);
        SpringApplication application = new SpringApplication(Config.class);
        application.setWebEnvironment(false);
        application.addListeners(new ApplicationListener<ContextRefreshedEvent>(){

            public void onApplicationEvent(ContextRefreshedEvent event) {
                try {
                    Assert.assertFalse((String)"Application should not be ready yet", (boolean)SpringApplicationAdminMXBeanRegistrarTests.this.isCurrentApplicationReady(objectName));
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Could not contact spring application admin bean", ex);
                }
            }
        });
        this.context = application.run(new String[0]);
        Assert.assertTrue((String)"application should be ready now", (boolean)this.isCurrentApplicationReady(objectName));
    }

    @Test
    public void shutdownApp() throws InstanceNotFoundException {
        ObjectName objectName = this.createObjectName(OBJECT_NAME);
        SpringApplication application = new SpringApplication(Config.class);
        application.setWebEnvironment(false);
        this.context = application.run(new String[0]);
        Assert.assertTrue((String)"application should be running", (boolean)this.context.isRunning());
        this.invokeShutdown(objectName);
        Assert.assertFalse((String)"application should not be running", (boolean)this.context.isRunning());
        this.thrown.expect(InstanceNotFoundException.class);
        this.mBeanServer.getObjectInstance(objectName);
    }

    private Boolean isCurrentApplicationReady(ObjectName objectName) {
        try {
            return (Boolean)this.mBeanServer.getAttribute(objectName, "Ready");
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    private void invokeShutdown(ObjectName objectName) {
        try {
            this.mBeanServer.invoke(objectName, "shutdown", null, null);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    private ObjectName createObjectName(String jmxName) {
        try {
            return new ObjectName(jmxName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Invalid jmx name " + jmxName, e);
        }
    }

    @Configuration
    static class Config {
        Config() {
        }

        @Bean
        public SpringApplicationAdminMXBeanRegistrar springApplicationAdminRegistrar() throws MalformedObjectNameException {
            return new SpringApplicationAdminMXBeanRegistrar(SpringApplicationAdminMXBeanRegistrarTests.OBJECT_NAME);
        }
    }
}

