/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cloudfoundry;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class VcapEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final Log logger = LogFactory.getLog(VcapEnvironmentPostProcessor.class);
    private static final String VCAP_APPLICATION = "VCAP_APPLICATION";
    private static final String VCAP_SERVICES = "VCAP_SERVICES";
    private int order = -2147483639;
    private final JsonParser parser = JsonParserFactory.getJsonParser();

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!environment.containsProperty(VCAP_APPLICATION) && !environment.containsProperty(VCAP_SERVICES)) {
            return;
        }
        Properties properties = new Properties();
        this.addWithPrefix(properties, this.getPropertiesFromApplication((Environment)environment), "vcap.application.");
        this.addWithPrefix(properties, this.getPropertiesFromServices((Environment)environment), "vcap.services.");
        MutablePropertySources propertySources = environment.getPropertySources();
        if (propertySources.contains("commandLineArgs")) {
            propertySources.addAfter("commandLineArgs", (PropertySource)new PropertiesPropertySource("vcap", properties));
        } else {
            propertySources.addFirst((PropertySource)new PropertiesPropertySource("vcap", properties));
        }
    }

    private void addWithPrefix(Properties properties, Properties other, String prefix) {
        for (String key : other.stringPropertyNames()) {
            String prefixed = prefix + key;
            properties.setProperty(prefixed, other.getProperty(key));
        }
    }

    private Properties getPropertiesFromApplication(Environment environment) {
        Properties properties = new Properties();
        try {
            Map<String, Object> map = this.parser.parseMap(environment.getProperty(VCAP_APPLICATION, "{}"));
            this.extractPropertiesFromApplication(properties, map);
        }
        catch (Exception ex) {
            logger.error((Object)"Could not parse VCAP_APPLICATION", (Throwable)ex);
        }
        return properties;
    }

    private Properties getPropertiesFromServices(Environment environment) {
        Properties properties = new Properties();
        try {
            Map<String, Object> map = this.parser.parseMap(environment.getProperty(VCAP_SERVICES, "{}"));
            this.extractPropertiesFromServices(properties, map);
        }
        catch (Exception ex) {
            logger.error((Object)"Could not parse VCAP_SERVICES", (Throwable)ex);
        }
        return properties;
    }

    private void extractPropertiesFromApplication(Properties properties, Map<String, Object> map) {
        if (map != null) {
            this.flatten(properties, map, "");
        }
    }

    private void extractPropertiesFromServices(Properties properties, Map<String, Object> map) {
        if (map != null) {
            for (Object services : map.values()) {
                List list = (List)services;
                for (Object object : list) {
                    Map service = (Map)object;
                    String key = (String)service.get("name");
                    if (key == null) {
                        key = (String)service.get("label");
                    }
                    this.flatten(properties, service, key);
                }
            }
        }
    }

    private void flatten(Properties properties, Map<String, Object> input, String path) {
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            String key = this.getFullKey(path, entry.getKey());
            Object value = entry.getValue();
            if (value instanceof Map) {
                this.flatten(properties, (Map)value, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                properties.put(key, StringUtils.collectionToCommaDelimitedString((Collection)collection));
                int count = 0;
                for (Object item : collection) {
                    String itemKey = "[" + count++ + "]";
                    this.flatten(properties, Collections.singletonMap(itemKey, item), key);
                }
                continue;
            }
            if (value instanceof String) {
                properties.put(key, value);
                continue;
            }
            if (value instanceof Number) {
                properties.put(key, value.toString());
                continue;
            }
            if (value instanceof Boolean) {
                properties.put(key, value.toString());
                continue;
            }
            properties.put(key, value == null ? "" : value);
        }
    }

    private String getFullKey(String path, String key) {
        if (!StringUtils.hasText((String)path)) {
            return key;
        }
        if (key.startsWith("[")) {
            return path + key;
        }
        return path + "." + key;
    }
}

