/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.RequestHeaderAttribute;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.util.HttpString;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.embedded.Compression;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.xnio.channels.BoundChannel;

public class UndertowEmbeddedServletContainer
implements EmbeddedServletContainer {
    private static final Log logger = LogFactory.getLog(UndertowEmbeddedServletContainer.class);
    private final Undertow.Builder builder;
    private final DeploymentManager manager;
    private final String contextPath;
    private final boolean useForwardHeaders;
    private final boolean autoStart;
    private final Compression compression;
    private Undertow undertow;
    private boolean started = false;

    public UndertowEmbeddedServletContainer(Undertow.Builder builder, DeploymentManager manager, String contextPath, int port, boolean autoStart, Compression compression) {
        this(builder, manager, contextPath, port, false, autoStart, compression);
    }

    public UndertowEmbeddedServletContainer(Undertow.Builder builder, DeploymentManager manager, String contextPath, int port, boolean useForwardHeaders, boolean autoStart, Compression compression) {
        this.builder = builder;
        this.manager = manager;
        this.contextPath = contextPath;
        this.useForwardHeaders = useForwardHeaders;
        this.autoStart = autoStart;
        this.compression = compression;
    }

    @Override
    public synchronized void start() throws EmbeddedServletContainerException {
        try {
            if (!this.autoStart) {
                return;
            }
            if (this.undertow == null) {
                this.undertow = this.createUndertowServer();
            }
            this.undertow.start();
            this.started = true;
            logger.info((Object)("Undertow started on port(s) " + this.getPortsDescription()));
        }
        catch (ServletException ex) {
            throw new EmbeddedServletContainerException("Unable to start embdedded Undertow", ex);
        }
    }

    private Undertow createUndertowServer() throws ServletException {
        HttpHandler httpHandler = this.manager.start();
        httpHandler = this.getContextHandler(httpHandler);
        if (this.useForwardHeaders) {
            httpHandler = Handlers.proxyPeerAddress((HttpHandler)httpHandler);
        }
        this.builder.setHandler(httpHandler);
        return this.builder.build();
    }

    private HttpHandler getContextHandler(HttpHandler httpHandler) {
        HttpHandler contextHandler = this.configurationCompressionIfNecessary(httpHandler);
        if (StringUtils.isEmpty((Object)this.contextPath)) {
            return contextHandler;
        }
        return Handlers.path().addPrefixPath(this.contextPath, contextHandler);
    }

    private HttpHandler configurationCompressionIfNecessary(HttpHandler httpHandler) {
        if (this.compression == null || !this.compression.getEnabled()) {
            return httpHandler;
        }
        ContentEncodingRepository repository = new ContentEncodingRepository();
        repository.addEncodingHandler("gzip", (ContentEncodingProvider)new GzipEncodingProvider(), 50, Predicates.and((Predicate[])this.getCompressionPredicates(this.compression)));
        return new EncodingHandler(repository).setNext(httpHandler);
    }

    private Predicate[] getCompressionPredicates(Compression compression) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(Predicates.maxContentSize((long)compression.getMinResponseSize()));
        predicates.add(new CompressibleMimeTypePredicate(compression.getMimeTypes()));
        if (compression.getExcludedUserAgents() != null) {
            for (String agent : compression.getExcludedUserAgents()) {
                RequestHeaderAttribute agentHeader = new RequestHeaderAttribute(new HttpString("User-Agent"));
                predicates.add(Predicates.not((Predicate)Predicates.regex((ExchangeAttribute)agentHeader, (String)agent)));
            }
        }
        return predicates.toArray(new Predicate[predicates.size()]);
    }

    private String getPortsDescription() {
        List<Port> ports = this.getPorts();
        if (!ports.isEmpty()) {
            return StringUtils.collectionToDelimitedString(ports, (String)" ");
        }
        return "unknown";
    }

    private List<Port> getPorts() {
        ArrayList<Port> ports = new ArrayList<Port>();
        try {
            if (!this.autoStart) {
                ports.add(new Port(-1, "unknown"));
            } else {
                for (BoundChannel channel : this.extractChannels()) {
                    ports.add(this.getPortFromChannel(channel));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ports;
    }

    private List<BoundChannel> extractChannels() {
        Field channelsField = ReflectionUtils.findField(Undertow.class, (String)"channels");
        ReflectionUtils.makeAccessible((Field)channelsField);
        return (List)ReflectionUtils.getField((Field)channelsField, (Object)this.undertow);
    }

    private Port getPortFromChannel(BoundChannel channel) {
        String protocol = ReflectionUtils.findField(channel.getClass(), (String)"ssl") != null ? "https" : "http";
        SocketAddress socketAddress = channel.getLocalAddress();
        if (socketAddress instanceof InetSocketAddress) {
            return new Port(((InetSocketAddress)socketAddress).getPort(), protocol);
        }
        return null;
    }

    @Override
    public synchronized void stop() throws EmbeddedServletContainerException {
        if (this.started) {
            try {
                this.started = false;
                this.manager.stop();
                this.undertow.stop();
            }
            catch (Exception ex) {
                throw new EmbeddedServletContainerException("Unable to stop undertow", ex);
            }
        }
    }

    @Override
    public int getPort() {
        List<Port> ports = this.getPorts();
        if (ports.isEmpty()) {
            return 0;
        }
        return ports.get(0).getNumber();
    }

    private static class CompressibleMimeTypePredicate
    implements Predicate {
        private final List<MimeType> mimeTypes;

        CompressibleMimeTypePredicate(String[] mimeTypes) {
            this.mimeTypes = new ArrayList<MimeType>(mimeTypes.length);
            for (String mimeTypeString : mimeTypes) {
                this.mimeTypes.add(MimeTypeUtils.parseMimeType((String)mimeTypeString));
            }
        }

        public boolean resolve(HttpServerExchange value) {
            String contentType = value.getResponseHeaders().getFirst("Content-Type");
            if (contentType != null) {
                for (MimeType mimeType : this.mimeTypes) {
                    if (!mimeType.isCompatibleWith(MimeTypeUtils.parseMimeType((String)contentType))) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class Port {
        private final int number;
        private final String protocol;

        private Port(int number, String protocol) {
            this.number = number;
            this.protocol = protocol;
        }

        public int getNumber() {
            return this.number;
        }

        public String toString() {
            return this.number + " (" + this.protocol + ")";
        }
    }
}

