/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import org.springframework.boot.json.JsonParser;

public class GsonJsonParser
implements JsonParser {
    private Gson gson = new GsonBuilder().create();

    @Override
    public Map<String, Object> parseMap(String json) {
        if (json != null && (json = json.trim()).startsWith("{")) {
            return (Map)this.gson.fromJson(json, new MapTypeToken().getType());
        }
        throw new IllegalArgumentException("Cannot parse JSON");
    }

    @Override
    public List<Object> parseList(String json) {
        if (json != null && (json = json.trim()).startsWith("[")) {
            TypeToken<List<Object>> type = new TypeToken<List<Object>>(){};
            return (List)this.gson.fromJson(json, type.getType());
        }
        throw new IllegalArgumentException("Cannot parse JSON");
    }

    private static final class MapTypeToken
    extends TypeToken<Map<String, Object>> {
        private MapTypeToken() {
        }
    }
}

