/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.orm.jpa;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.orm.jpa.EntityScan;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@Deprecated
class EntityScanRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final String BEAN_NAME = "entityScanBeanPostProcessor";

    EntityScanRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Set<String> packagesToScan = this.getPackagesToScan(importingClassMetadata);
        if (!registry.containsBeanDefinition(BEAN_NAME)) {
            this.addEntityScanBeanPostProcessor(registry, packagesToScan);
        } else {
            this.updateEntityScanBeanPostProcessor(registry, packagesToScan);
        }
    }

    private Set<String> getPackagesToScan(AnnotationMetadata metadata) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(EntityScan.class.getName()));
        String[] basePackages = attributes.getStringArray("basePackages");
        Class[] basePackageClasses = attributes.getClassArray("basePackageClasses");
        LinkedHashSet<String> packagesToScan = new LinkedHashSet<String>();
        packagesToScan.addAll(Arrays.asList(basePackages));
        for (Class basePackageClass : basePackageClasses) {
            packagesToScan.add(ClassUtils.getPackageName((Class)basePackageClass));
        }
        if (packagesToScan.isEmpty()) {
            return Collections.singleton(ClassUtils.getPackageName((String)metadata.getClassName()));
        }
        return packagesToScan;
    }

    private void addEntityScanBeanPostProcessor(BeanDefinitionRegistry registry, Set<String> packagesToScan) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(EntityScanBeanPostProcessor.class);
        beanDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)this.toArray(packagesToScan));
        beanDefinition.setRole(2);
        beanDefinition.setSynthetic(true);
        registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)beanDefinition);
    }

    private void updateEntityScanBeanPostProcessor(BeanDefinitionRegistry registry, Set<String> packagesToScan) {
        BeanDefinition definition = registry.getBeanDefinition(BEAN_NAME);
        ConstructorArgumentValues.ValueHolder constructorArguments = definition.getConstructorArgumentValues().getGenericArgumentValue(String[].class);
        LinkedHashSet<String> mergedPackages = new LinkedHashSet<String>();
        mergedPackages.addAll(Arrays.asList((String[])constructorArguments.getValue()));
        mergedPackages.addAll(packagesToScan);
        constructorArguments.setValue((Object)this.toArray(mergedPackages));
    }

    private String[] toArray(Set<String> set) {
        return set.toArray(new String[set.size()]);
    }

    static class EntityScanBeanPostProcessor
    implements BeanPostProcessor,
    SmartInitializingSingleton,
    Ordered {
        private final String[] packagesToScan;
        private boolean processed;

        EntityScanBeanPostProcessor(String[] packagesToScan) {
            this.packagesToScan = packagesToScan;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof LocalContainerEntityManagerFactoryBean) {
                LocalContainerEntityManagerFactoryBean factoryBean = (LocalContainerEntityManagerFactoryBean)bean;
                factoryBean.setPackagesToScan(this.packagesToScan);
                this.processed = true;
            }
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public void afterSingletonsInstantiated() {
            Assert.state((boolean)this.processed, (String)"Unable to configure LocalContainerEntityManagerFactoryBean from @EntityScan, ensure an appropriate bean is registered.");
        }

        public int getOrder() {
            return 0;
        }
    }
}

