/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingException;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.bind.handler.IgnoreErrorsBindHandler;
import org.springframework.boot.context.properties.bind.handler.NoUnboundElementsBindHandler;
import org.springframework.boot.context.properties.bind.validation.ValidationBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.context.properties.source.UnboundElementsSourceFilter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class ConfigurationPropertiesBinder {
    private final Iterable<PropertySource<?>> propertySources;
    private final ConversionService conversionService;
    private final Validator validator;
    private Iterable<ConfigurationPropertySource> configurationSources;

    ConfigurationPropertiesBinder(Iterable<PropertySource<?>> propertySources, ConversionService conversionService, Validator validator) {
        Assert.notNull(propertySources, (String)"PropertySources must not be null");
        this.propertySources = propertySources;
        this.conversionService = conversionService;
        this.validator = validator;
        this.configurationSources = propertySources instanceof MutablePropertySources ? ConfigurationPropertySources.from((MutablePropertySources)propertySources) : ConfigurationPropertySources.from(propertySources);
    }

    public void bind(Object target) {
        ConfigurationProperties annotation = (ConfigurationProperties)AnnotationUtils.findAnnotation(target.getClass(), ConfigurationProperties.class);
        if (annotation != null) {
            this.bind(target, annotation);
        }
    }

    void bind(Object target, ConfigurationProperties annotation) {
        Binder binder = new Binder(this.configurationSources, new PropertySourcesPlaceholdersResolver(this.propertySources), this.conversionService);
        Validator validator = this.determineValidator(target);
        BindHandler handler = this.getBindHandler(annotation, validator);
        Bindable<Object> bindable = Bindable.ofInstance(target);
        try {
            binder.bind(annotation.prefix(), bindable, handler);
        }
        catch (Exception ex) {
            throw new ConfigurationPropertiesBindingException(target.getClass(), this.getAnnotationDetails(annotation), ex);
        }
    }

    void destroy() {
        if (this.validator instanceof InternalValidator) {
            ((InternalValidator)this.validator).destroy();
        }
    }

    private Validator determineValidator(Object bean) {
        boolean supportsBean;
        boolean bl = supportsBean = this.validator != null && this.validator.supports(bean.getClass());
        if (ClassUtils.isAssignable(Validator.class, bean.getClass())) {
            if (supportsBean) {
                return new ChainingValidator(this.validator, (Validator)bean);
            }
            return (Validator)bean;
        }
        return supportsBean ? this.validator : null;
    }

    private BindHandler getBindHandler(ConfigurationProperties annotation, Validator validator) {
        BindHandler handler = BindHandler.DEFAULT;
        if (annotation.ignoreInvalidFields()) {
            handler = new IgnoreErrorsBindHandler(handler);
        }
        if (!annotation.ignoreUnknownFields()) {
            UnboundElementsSourceFilter filter = new UnboundElementsSourceFilter();
            handler = new NoUnboundElementsBindHandler(handler, filter);
        }
        if (validator != null) {
            handler = new ValidationBindHandler(handler, validator);
        }
        return handler;
    }

    private String getAnnotationDetails(ConfigurationProperties annotation) {
        if (annotation == null) {
            return "";
        }
        StringBuilder details = new StringBuilder();
        details.append("prefix=").append(annotation.prefix());
        details.append(", ignoreInvalidFields=").append(annotation.ignoreInvalidFields());
        details.append(", ignoreUnknownFields=").append(annotation.ignoreUnknownFields());
        return details.toString();
    }

    private static class ChainingValidator
    implements Validator {
        private final Validator[] validators;

        ChainingValidator(Validator ... validators) {
            Assert.notNull((Object)validators, (String)"Validators must not be null");
            this.validators = validators;
        }

        public boolean supports(Class<?> clazz) {
            for (Validator validator : this.validators) {
                if (!validator.supports(clazz)) continue;
                return true;
            }
            return false;
        }

        public void validate(Object target, Errors errors) {
            for (Validator validator : this.validators) {
                if (!validator.supports(target.getClass())) continue;
                validator.validate(target, errors);
            }
        }
    }

    static interface InternalValidator
    extends Validator {
        public void destroy();
    }
}

