/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.reactive.context;

import org.springframework.beans.BeansException;
import org.springframework.boot.web.reactive.context.GenericReactiveWebApplicationContext;
import org.springframework.boot.web.reactive.context.ReactiveWebServerInitializedEvent;
import org.springframework.boot.web.reactive.server.ReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationContextException;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.StringUtils;

public class ReactiveWebServerApplicationContext
extends GenericReactiveWebApplicationContext {
    private volatile WebServer webServer;

    public ReactiveWebServerApplicationContext() {
    }

    public ReactiveWebServerApplicationContext(Class<?> ... annotatedClasses) {
        super(annotatedClasses);
    }

    public final void refresh() throws BeansException, IllegalStateException {
        try {
            super.refresh();
        }
        catch (RuntimeException ex) {
            this.stopAndReleaseReactiveWebServer();
            throw ex;
        }
    }

    protected void onRefresh() {
        super.onRefresh();
        try {
            this.createWebServer();
        }
        catch (Throwable ex) {
            throw new ApplicationContextException("Unable to start reactive web server", ex);
        }
    }

    protected void finishRefresh() {
        super.finishRefresh();
        WebServer localServer = this.startReactiveWebServer();
        if (localServer != null) {
            this.publishEvent(new ReactiveWebServerInitializedEvent(localServer, this));
        }
    }

    protected void onClose() {
        super.onClose();
        this.stopAndReleaseReactiveWebServer();
    }

    private void createWebServer() {
        WebServer localServer = this.webServer;
        if (localServer == null) {
            this.webServer = this.getWebServerFactory().getWebServer(this.getHttpHandler());
        }
        this.initPropertySources();
    }

    protected ReactiveWebServerFactory getWebServerFactory() {
        Object[] beanNames = this.getBeanFactory().getBeanNamesForType(ReactiveWebServerFactory.class);
        if (beanNames.length == 0) {
            throw new ApplicationContextException("Unable to start ReactiveWebApplicationContext due to missing ReactiveWebServerFactory bean.");
        }
        if (beanNames.length > 1) {
            throw new ApplicationContextException("Unable to start ReactiveWebApplicationContext due to multiple ReactiveWebServerFactory beans : " + StringUtils.arrayToCommaDelimitedString((Object[])beanNames));
        }
        return (ReactiveWebServerFactory)this.getBeanFactory().getBean(beanNames[0], ReactiveWebServerFactory.class);
    }

    protected HttpHandler getHttpHandler() {
        Object[] beanNames = this.getBeanFactory().getBeanNamesForType(HttpHandler.class);
        if (beanNames.length == 0) {
            throw new ApplicationContextException("Unable to start ReactiveWebApplicationContext due to missing HttpHandler bean.");
        }
        if (beanNames.length > 1) {
            throw new ApplicationContextException("Unable to start ReactiveWebApplicationContext due to multiple HttpHandler beans : " + StringUtils.arrayToCommaDelimitedString((Object[])beanNames));
        }
        return (HttpHandler)this.getBeanFactory().getBean(beanNames[0], HttpHandler.class);
    }

    private WebServer startReactiveWebServer() {
        WebServer localServer = this.webServer;
        if (localServer != null) {
            localServer.start();
        }
        return localServer;
    }

    private void stopAndReleaseReactiveWebServer() {
        WebServer localServer = this.webServer;
        if (localServer != null) {
            try {
                localServer.stop();
                this.webServer = null;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

