/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.system;

import java.io.Console;
import java.text.NumberFormat;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.Future;
import org.springframework.util.ClassUtils;

public enum JavaVersion {
    SEVENTEEN("17", Console.class, "charset"),
    EIGHTEEN("18", Duration.class, "isPositive"),
    NINETEEN("19", Future.class, "state"),
    TWENTY("20", Class.class, "accessFlags"),
    TWENTY_ONE("21", SortedSet.class, "getFirst"),
    TWENTY_TWO("22", Console.class, "isTerminal"),
    TWENTY_THREE("23", NumberFormat.class, "isStrict");

    private final String name;
    private final boolean available;

    private JavaVersion(String name, Class<?> versionSpecificClass, String versionSpecificMethod) {
        this.name = name;
        this.available = ClassUtils.hasMethod(versionSpecificClass, (String)versionSpecificMethod, (Class[])new Class[0]);
    }

    public String toString() {
        return this.name;
    }

    public static JavaVersion getJavaVersion() {
        List<JavaVersion> candidates = Arrays.asList(JavaVersion.values());
        Collections.reverse(candidates);
        for (JavaVersion candidate : candidates) {
            if (!candidate.available) continue;
            return candidate;
        }
        return SEVENTEEN;
    }

    public boolean isEqualOrNewerThan(JavaVersion version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isOlderThan(JavaVersion version) {
        return this.compareTo(version) < 0;
    }
}

