/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.util;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class LambdaSafe {
    private static final @Nullable Method CLASS_GET_MODULE = ReflectionUtils.findMethod(Class.class, (String)"getModule");
    private static final @Nullable Method MODULE_GET_NAME = CLASS_GET_MODULE != null ? ReflectionUtils.findMethod(CLASS_GET_MODULE.getReturnType(), (String)"getName") : null;

    private LambdaSafe() {
    }

    public static <C, A> Callback<C, A> callback(Class<C> callbackType, C callbackInstance, A argument, Object ... additionalArguments) {
        Assert.notNull(callbackType, (String)"'callbackType' must not be null");
        Assert.notNull(callbackInstance, (String)"'callbackInstance' must not be null");
        return new Callback<C, A>(callbackType, callbackInstance, argument, additionalArguments);
    }

    public static <C, A> Callbacks<C, A> callbacks(Class<C> callbackType, Collection<? extends C> callbackInstances, A argument, Object ... additionalArguments) {
        Assert.notNull(callbackType, (String)"'callbackType' must not be null");
        Assert.notNull(callbackInstances, (String)"'callbackInstances' must not be null");
        return new Callbacks<C, A>(callbackType, callbackInstances, argument, additionalArguments);
    }

    public static final class Callback<C, A>
    extends LambdaSafeCallback<C, A, Callback<C, A>> {
        private final C callbackInstance;

        private Callback(Class<C> callbackType, C callbackInstance, A argument, @Nullable Object @Nullable [] additionalArguments) {
            super(callbackType, argument, additionalArguments);
            this.callbackInstance = callbackInstance;
        }

        public void invoke(Consumer<C> invoker) {
            Supplier<@Nullable Void> supplier = () -> {
                invoker.accept(this.callbackInstance);
                return null;
            };
            this.invoke(this.callbackInstance, supplier);
        }

        public <R> InvocationResult<R> invokeAnd(Function<C, @Nullable R> invoker) {
            Supplier<@Nullable Object> supplier = () -> invoker.apply(this.callbackInstance);
            return this.invoke(this.callbackInstance, supplier);
        }
    }

    public static final class Callbacks<C, A>
    extends LambdaSafeCallback<C, A, Callbacks<C, A>> {
        private final Collection<? extends C> callbackInstances;

        private Callbacks(Class<C> callbackType, Collection<? extends C> callbackInstances, A argument, Object[] additionalArguments) {
            super(callbackType, argument, additionalArguments);
            this.callbackInstances = callbackInstances;
        }

        public void invoke(Consumer<C> invoker) {
            this.callbackInstances.forEach(callbackInstance -> {
                Supplier<@Nullable Void> supplier = () -> {
                    invoker.accept(callbackInstance);
                    return null;
                };
                this.invoke(callbackInstance, supplier);
            });
        }

        public <R> Stream<R> invokeAnd(Function<C, @Nullable R> invoker) {
            Function<Object, InvocationResult> mapper = callbackInstance -> {
                Supplier<@Nullable Object> supplier = () -> invoker.apply(callbackInstance);
                return this.invoke(callbackInstance, supplier);
            };
            return this.callbackInstances.stream().map(mapper).filter(InvocationResult::hasResult).map(InvocationResult::get);
        }
    }

    public static final class InvocationResult<R> {
        private static final InvocationResult<?> NONE = new InvocationResult<Object>(null);
        private final @Nullable R value;

        private InvocationResult(@Nullable R value) {
            this.value = value;
        }

        public boolean hasResult() {
            return this != NONE;
        }

        public @Nullable R get() {
            return this.value;
        }

        public @Nullable R get(@Nullable R fallback) {
            return this != NONE ? this.value : fallback;
        }

        public static <R> InvocationResult<R> of(@Nullable R value) {
            return new InvocationResult<R>(value);
        }

        public static <R> InvocationResult<R> noResult() {
            return NONE;
        }
    }

    private static final class GenericTypeFilter<C, A>
    implements Filter<C, A> {
        private GenericTypeFilter() {
        }

        @Override
        public boolean match(Class<C> callbackType, C callbackInstance, A argument, @Nullable Object @Nullable [] additionalArguments) {
            ResolvableType type = ResolvableType.forClass(callbackType, callbackInstance.getClass());
            if (type.getGenerics().length != 1) {
                return true;
            }
            Class generic = type.resolveGeneric(new int[0]);
            if (generic != null) {
                return generic.isInstance(argument);
            }
            return true;
        }
    }

    @FunctionalInterface
    public static interface Filter<C, A> {
        public boolean match(Class<C> var1, C var2, A var3, @Nullable Object @Nullable [] var4);

        public static <C, A> Filter<C, A> allowAll() {
            return (callbackType, callbackInstance, argument, additionalArguments) -> true;
        }
    }

    protected static abstract class LambdaSafeCallback<C, A, SELF extends LambdaSafeCallback<C, A, SELF>> {
        private final Class<C> callbackType;
        private final A argument;
        private final @Nullable Object @Nullable [] additionalArguments;
        private Log logger;
        private Filter<C, A> filter = new GenericTypeFilter();

        LambdaSafeCallback(Class<C> callbackType, A argument, @Nullable Object @Nullable [] additionalArguments) {
            this.callbackType = callbackType;
            this.argument = argument;
            this.additionalArguments = additionalArguments;
            this.logger = LogFactory.getLog(callbackType);
        }

        public SELF withLogger(Class<?> loggerSource) {
            return this.withLogger(LogFactory.getLog(loggerSource));
        }

        public SELF withLogger(Log logger) {
            Assert.notNull((Object)logger, (String)"'logger' must not be null");
            this.logger = logger;
            return this.self();
        }

        public SELF withFilter(Filter<C, A> filter) {
            Assert.notNull(filter, (String)"'filter' must not be null");
            this.filter = filter;
            return this.self();
        }

        protected final <R> InvocationResult<R> invoke(C callbackInstance, Supplier<@Nullable R> supplier) {
            if (this.filter.match(this.callbackType, callbackInstance, this.argument, this.additionalArguments)) {
                try {
                    return InvocationResult.of(supplier.get());
                }
                catch (ClassCastException ex) {
                    if (!this.isLambdaGenericProblem(ex)) {
                        throw ex;
                    }
                    this.logNonMatchingType(callbackInstance, ex);
                }
            }
            return InvocationResult.noResult();
        }

        private boolean isLambdaGenericProblem(ClassCastException ex) {
            return ex.getMessage() == null || this.startsWithArgumentClassName(ex.getMessage());
        }

        private boolean startsWithArgumentClassName(String message) {
            Predicate<@Nullable Object> startsWith = argument -> this.startsWithArgumentClassName(message, argument);
            return startsWith.test(this.argument) || this.additionalArgumentsStartsWith(startsWith);
        }

        private boolean additionalArgumentsStartsWith(Predicate<@Nullable Object> startsWith) {
            if (this.additionalArguments == null) {
                return false;
            }
            return Stream.of(this.additionalArguments).anyMatch(startsWith);
        }

        private boolean startsWithArgumentClassName(String message, @Nullable Object argument) {
            if (argument == null) {
                return false;
            }
            Class<?> argumentType = argument.getClass();
            if (message.startsWith(argumentType.getName())) {
                return true;
            }
            if (message.startsWith(argumentType.toString())) {
                return true;
            }
            int moduleSeparatorIndex = message.indexOf(47);
            if (moduleSeparatorIndex != -1 && message.startsWith(argumentType.getName(), moduleSeparatorIndex + 1)) {
                return true;
            }
            if (CLASS_GET_MODULE != null && MODULE_GET_NAME != null) {
                Object module = ReflectionUtils.invokeMethod((Method)CLASS_GET_MODULE, argumentType);
                Object moduleName = ReflectionUtils.invokeMethod((Method)MODULE_GET_NAME, (Object)module);
                return message.startsWith(String.valueOf(moduleName) + "/" + argumentType.getName());
            }
            return false;
        }

        private void logNonMatchingType(C callback, ClassCastException ex) {
            if (this.logger.isDebugEnabled()) {
                Class expectedType = ResolvableType.forClass(this.callbackType).resolveGeneric(new int[0]);
                String expectedTypeName = expectedType != null ? ClassUtils.getShortName((Class)expectedType) + " type" : "type";
                String message = "Non-matching " + expectedTypeName + " for callback " + ClassUtils.getShortName(this.callbackType) + ": " + String.valueOf(callback);
                this.logger.debug((Object)message, (Throwable)ex);
            }
        }

        private SELF self() {
            return (SELF)this;
        }
    }
}

