/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.autoconfigure.context;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.AmazonCloudFormationClient;
import com.amazonaws.services.ec2.AmazonEC2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.aws.autoconfigure.context.ContextCredentialsAutoConfiguration;
import org.springframework.cloud.aws.autoconfigure.context.properties.AwsStackProperties;
import org.springframework.cloud.aws.context.annotation.ConditionalOnMissingAmazonClient;
import org.springframework.cloud.aws.context.config.annotation.ContextDefaultConfigurationRegistrar;
import org.springframework.cloud.aws.core.config.AmazonWebserviceClientFactoryBean;
import org.springframework.cloud.aws.core.env.stack.StackResourceRegistry;
import org.springframework.cloud.aws.core.env.stack.config.AutoDetectingStackNameProvider;
import org.springframework.cloud.aws.core.env.stack.config.StackNameProvider;
import org.springframework.cloud.aws.core.env.stack.config.StackResourceRegistryFactoryBean;
import org.springframework.cloud.aws.core.env.stack.config.StaticStackNameProvider;
import org.springframework.cloud.aws.core.region.RegionProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@Import(value={ContextCredentialsAutoConfiguration.class, ContextDefaultConfigurationRegistrar.class})
@ConditionalOnClass(name={"com.amazonaws.services.cloudformation.AmazonCloudFormation"})
@EnableConfigurationProperties(value={AwsStackProperties.class})
public class ContextStackAutoConfiguration {
    @Autowired
    private AwsStackProperties properties;
    @Autowired(required=false)
    private AmazonEC2 amazonEC2;
    @Autowired(required=false)
    private RegionProvider regionProvider;
    @Autowired(required=false)
    private AWSCredentialsProvider credentialsProvider;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"cloud.aws.stack.name"})
    public StackNameProvider staticStackNameProvider() {
        return new StaticStackNameProvider(this.properties.getName());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"cloud.aws.stack.auto"}, havingValue="true", matchIfMissing=true)
    public StackNameProvider autoDetectingStackNameProvider(AmazonCloudFormation amazonCloudFormation) {
        return new AutoDetectingStackNameProvider(amazonCloudFormation, this.amazonEC2);
    }

    @Bean
    @ConditionalOnMissingBean(value={StackResourceRegistry.class})
    @ConditionalOnBean(value={StackNameProvider.class})
    public StackResourceRegistryFactoryBean stackResourceRegistryFactoryBean(AmazonCloudFormation amazonCloudFormation, StackNameProvider stackNameProvider) {
        return new StackResourceRegistryFactoryBean(amazonCloudFormation, stackNameProvider);
    }

    @Bean
    @ConditionalOnMissingAmazonClient(value=AmazonCloudFormation.class)
    public AmazonWebserviceClientFactoryBean<AmazonCloudFormationClient> amazonCloudFormation() {
        return new AmazonWebserviceClientFactoryBean(AmazonCloudFormationClient.class, this.credentialsProvider, this.regionProvider);
    }
}

