/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.mail.simplemail;

import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.model.RawMessage;
import com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.amazonaws.services.simpleemail.model.SendRawEmailResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.aws.mail.simplemail.SimpleEmailServiceMailSender;
import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;
import org.springframework.mail.MailPreparationException;
import org.springframework.mail.MailSendException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class SimpleEmailServiceJavaMailSender
extends SimpleEmailServiceMailSender
implements JavaMailSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleEmailServiceMailSender.class);

    public SimpleEmailServiceJavaMailSender(AmazonSimpleEmailService amazonSimpleEmailService) {
        super(amazonSimpleEmailService);
    }

    public MimeMessage createMimeMessage() {
        return new MimeMessage(Session.getInstance((Properties)new Properties()));
    }

    public MimeMessage createMimeMessage(InputStream inputStream) throws MailException {
        try {
            return new MimeMessage(Session.getInstance((Properties)new Properties()), inputStream);
        }
        catch (MessagingException e) {
            throw new MailParseException("Could not parse raw MIME content", (Throwable)e);
        }
    }

    public void send(MimeMessage mimeMessage) throws MailException {
        this.send(new MimeMessage[]{mimeMessage});
    }

    public void send(MimeMessage ... mimeMessages) throws MailException {
        HashMap<MimeMessage, Exception> failedMessages = new HashMap<MimeMessage, Exception>();
        MimeMessage[] mimeMessageArray = mimeMessages;
        int n = mimeMessages.length;
        int n2 = 0;
        while (n2 < n) {
            MimeMessage mimeMessage = mimeMessageArray[n2];
            try {
                RawMessage rm = this.createRawMessage(mimeMessage);
                SendRawEmailResult sendRawEmailResult = this.getEmailService().sendRawEmail(new SendRawEmailRequest(rm));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Message with id: {0} successfully send", (Object)sendRawEmailResult.getMessageId());
                }
            }
            catch (Exception e) {
                failedMessages.put(mimeMessage, e);
            }
            ++n2;
        }
        if (!failedMessages.isEmpty()) {
            throw new MailSendException(failedMessages);
        }
    }

    public void send(MimeMessagePreparator mimeMessagePreparator) throws MailException {
        this.send(new MimeMessagePreparator[]{mimeMessagePreparator});
    }

    public void send(MimeMessagePreparator ... mimeMessagePreparators) throws MailException {
        MimeMessage mimeMessage = this.createMimeMessage();
        MimeMessagePreparator[] mimeMessagePreparatorArray = mimeMessagePreparators;
        int n = mimeMessagePreparators.length;
        int n2 = 0;
        while (n2 < n) {
            MimeMessagePreparator mimeMessagePreparator = mimeMessagePreparatorArray[n2];
            try {
                mimeMessagePreparator.prepare(mimeMessage);
            }
            catch (Exception e) {
                throw new MailPreparationException((Throwable)e);
            }
            ++n2;
        }
        this.send(mimeMessage);
    }

    private RawMessage createRawMessage(MimeMessage mimeMessage) {
        ByteArrayOutputStream out;
        try {
            out = new ByteArrayOutputStream();
            mimeMessage.writeTo((OutputStream)out);
        }
        catch (IOException e) {
            throw new MailPreparationException((Throwable)e);
        }
        catch (MessagingException e) {
            throw new MailParseException((Throwable)e);
        }
        return new RawMessage(ByteBuffer.wrap(out.toByteArray()));
    }
}

