/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.jdbc.datasource;

import java.sql.Connection;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.aws.jdbc.datasource.DataSourceFactory;
import org.springframework.cloud.aws.jdbc.datasource.DataSourceInformation;
import org.springframework.cloud.aws.jdbc.datasource.support.DatabasePlatformSupport;
import org.springframework.cloud.aws.jdbc.datasource.support.StaticDatabasePlatformSupport;
import org.springframework.core.Constants;

public class TomcatJdbcDataSourceFactory
extends PoolProperties
implements DataSourceFactory {
    private static final String PREFIX_ISOLATION = "TRANSACTION_";
    private DatabasePlatformSupport databasePlatformSupport = new StaticDatabasePlatformSupport();

    public void setUsername(String username) {
        throw new UnsupportedOperationException("Username will be set at runtime!");
    }

    public void setPassword(String password) {
        throw new UnsupportedOperationException("Password will be set at runtime!");
    }

    public void setDriverClassName(String driverClassName) {
        throw new UnsupportedOperationException("Will be set at runtime!");
    }

    public void setUrl(String url) {
        throw new UnsupportedOperationException("Will be set at runtime!");
    }

    public void setDefaultTransactionIsolationName(String constantName) {
        if (constantName == null) {
            throw new IllegalArgumentException("Isolation name must not be null");
        }
        Constants constants = new Constants(Connection.class);
        this.setDefaultTransactionIsolation(constants.asNumber(PREFIX_ISOLATION + constantName).intValue());
    }

    public void setDatabasePlatformSupport(DatabasePlatformSupport databasePlatformSupport) {
        this.databasePlatformSupport = databasePlatformSupport;
    }

    public DataSource createDataSource(DataSourceInformation dataSourceInformation) {
        PoolProperties configurationToUse = new PoolProperties();
        BeanUtils.copyProperties((Object)this, (Object)configurationToUse);
        configurationToUse.setDriverClassName(this.databasePlatformSupport.getDriverClassNameForDatabase(dataSourceInformation.getDatabaseType()));
        configurationToUse.setUrl(this.databasePlatformSupport.getDatabaseUrlForDatabase(dataSourceInformation.getDatabaseType(), dataSourceInformation.getHostName(), dataSourceInformation.getPort(), dataSourceInformation.getDatabaseName()));
        configurationToUse.setUsername(dataSourceInformation.getUserName());
        configurationToUse.setPassword(dataSourceInformation.getPassword());
        return new DataSource((PoolConfiguration)configurationToUse);
    }

    @Override
    public void closeDataSource(javax.sql.DataSource dataSource) {
        if (dataSource instanceof DataSource) {
            ((DataSource)dataSource).close();
        }
    }
}

