/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.config.annotation;

import com.amazonaws.services.sqs.AmazonSQSAsync;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.aws.context.config.annotation.ContextDefaultConfigurationRegistrar;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.cloud.aws.messaging.config.QueueMessageHandlerFactory;
import org.springframework.cloud.aws.messaging.config.SimpleMessageListenerContainerFactory;
import org.springframework.cloud.aws.messaging.listener.QueueMessageHandler;
import org.springframework.cloud.aws.messaging.listener.SimpleMessageListenerContainer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={ContextDefaultConfigurationRegistrar.class})
public class SqsConfiguration {
    @Autowired
    public BeanFactory beanFactory;
    @Autowired(required=false)
    private ResourceIdResolver resourceIdResolver;
    @Autowired(required=false)
    private final SimpleMessageListenerContainerFactory simpleMessageListenerContainerFactory = new SimpleMessageListenerContainerFactory();
    @Autowired(required=false)
    private final QueueMessageHandlerFactory queueMessageHandlerFactory = new QueueMessageHandlerFactory();

    @Bean
    public SimpleMessageListenerContainer simpleMessageListenerContainer(AmazonSQSAsync amazonSqs) {
        if (this.simpleMessageListenerContainerFactory.getAmazonSqs() == null) {
            this.simpleMessageListenerContainerFactory.setAmazonSqs(amazonSqs);
        }
        if (this.simpleMessageListenerContainerFactory.getResourceIdResolver() == null) {
            this.simpleMessageListenerContainerFactory.setResourceIdResolver(this.resourceIdResolver);
        }
        SimpleMessageListenerContainer simpleMessageListenerContainer = this.simpleMessageListenerContainerFactory.createSimpleMessageListenerContainer();
        simpleMessageListenerContainer.setMessageHandler(this.queueMessageHandler(amazonSqs));
        return simpleMessageListenerContainer;
    }

    @Bean
    public QueueMessageHandler queueMessageHandler(AmazonSQSAsync amazonSqs) {
        if (this.simpleMessageListenerContainerFactory.getQueueMessageHandler() != null) {
            return this.simpleMessageListenerContainerFactory.getQueueMessageHandler();
        }
        return this.getMessageHandler(amazonSqs);
    }

    private QueueMessageHandler getMessageHandler(AmazonSQSAsync amazonSqs) {
        if (this.queueMessageHandlerFactory.getAmazonSqs() == null) {
            this.queueMessageHandlerFactory.setAmazonSqs(amazonSqs);
        }
        this.queueMessageHandlerFactory.setBeanFactory(this.beanFactory);
        return this.queueMessageHandlerFactory.createQueueMessageHandler();
    }
}

