/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cli.compiler;

import java.util.Iterator;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.autoconfigure.SpringIntegrationCompilerAutoConfiguration;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.SystemPropertyUtils;

public abstract class BaseStreamCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    private SpringIntegrationCompilerAutoConfiguration integration = new SpringIntegrationCompilerAutoConfiguration();

    public boolean matches(ClassNode classNode) {
        boolean annotated = AstUtils.hasAtLeastOneAnnotation((ClassNode)classNode, (String[])new String[]{"EnableBinding"});
        return annotated && BaseStreamCompilerAutoConfiguration.isTransport(classNode, this.getTransport());
    }

    protected abstract String getTransport();

    static boolean isTransport(ClassNode node, String type) {
        Iterator iterator = node.getAnnotations().iterator();
        while (iterator.hasNext()) {
            String transport;
            String annotation = "EnableBinding";
            AnnotationNode annotationNode = (AnnotationNode)iterator.next();
            if (!PatternMatchUtils.simpleMatch((String)annotation, (String)annotationNode.getClassNode().getName())) continue;
            Expression expression = (Expression)annotationNode.getMembers().get("transport");
            String string = transport = expression == null ? "rabbit" : expression.getText();
            if (transport != null) {
                transport = SystemPropertyUtils.resolvePlaceholders((String)transport);
            }
            return transport.equals(type);
        }
        return false;
    }

    public void applyImports(ImportCustomizer imports) throws CompilationFailedException {
        this.integration.applyImports(imports);
        imports.addImports(new String[]{"org.springframework.boot.groovy.cloud.EnableBinding"});
        imports.addImport("IntegrationMessageSource", "org.springframework.integration.core.MessageSource");
        imports.addStarImports(new String[]{"org.springframework.cloud.stream.annotation", "org.springframework.cloud.stream.messaging"});
    }
}

