/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry;

import java.util.List;
import java.util.Map;
import org.springframework.cloud.ServiceInfoCreator;
import org.springframework.cloud.cloudfoundry.Tags;
import org.springframework.cloud.service.ServiceInfo;

public abstract class CloudFoundryServiceInfoCreator<SI extends ServiceInfo>
implements ServiceInfoCreator<SI, Map<String, Object>> {
    private Tags tags;
    private String uriScheme;

    public CloudFoundryServiceInfoCreator(Tags tags, String uriScheme) {
        this.tags = tags;
        this.uriScheme = uriScheme;
    }

    public CloudFoundryServiceInfoCreator(Tags tags) {
        this(tags, null);
    }

    public boolean accept(Map<String, Object> serviceData) {
        return this.tagsMatch(serviceData) || this.labelStartsWithTag(serviceData) || this.uriMatchesScheme(serviceData);
    }

    protected boolean tagsMatch(Map<String, Object> serviceData) {
        List serviceTags = (List)serviceData.get("tags");
        return this.tags.containsOne(serviceTags);
    }

    protected boolean labelStartsWithTag(Map<String, Object> serviceData) {
        String label = (String)serviceData.get("label");
        return this.tags.startsWith(label);
    }

    protected boolean uriMatchesScheme(Map<String, Object> serviceData) {
        if (this.uriScheme == null) {
            return false;
        }
        Map credentials = (Map)serviceData.get("credentials");
        if (credentials != null) {
            String uri = (String)credentials.get("uri");
            if (uri == null) {
                uri = (String)credentials.get("url");
            }
            if (uri != null) {
                return uri.startsWith(this.uriScheme + "://");
            }
        }
        return false;
    }

    protected String getStringFromCredentials(Map<String, Object> credentials, String ... keys) {
        for (String key : keys) {
            if (!credentials.containsKey(key)) continue;
            return (String)credentials.get(key);
        }
        return null;
    }

    public String getUriScheme() {
        return this.uriScheme;
    }
}

