/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.lang.reflect.Array;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonParser;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonProcessingException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonToken;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.BeanProperty;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.DeserializationContext;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.DeserializationFeature;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.JavaType;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.JsonDeserializer;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.JsonMappingException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.type.ArrayType;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.util.ObjectBuffer;

@JacksonStdImpl
public class ObjectArrayDeserializer
extends ContainerDeserializerBase<Object[]>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final ArrayType _arrayType;
    protected final boolean _untyped;
    protected final Class<?> _elementClass;
    protected JsonDeserializer<Object> _elementDeserializer;
    protected final TypeDeserializer _elementTypeDeserializer;

    public ObjectArrayDeserializer(ArrayType arrayType, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        super(arrayType);
        this._arrayType = arrayType;
        this._elementClass = arrayType.getContentType().getRawClass();
        this._untyped = this._elementClass == Object.class;
        this._elementDeserializer = jsonDeserializer;
        this._elementTypeDeserializer = typeDeserializer;
    }

    public ObjectArrayDeserializer withDeserializer(TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        if (jsonDeserializer == this._elementDeserializer && typeDeserializer == this._elementTypeDeserializer) {
            return this;
        }
        return new ObjectArrayDeserializer(this._arrayType, jsonDeserializer, typeDeserializer);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._elementDeserializer;
        jsonDeserializer = (jsonDeserializer = this.findConvertingContentDeserializer(deserializationContext, beanProperty, jsonDeserializer)) == null ? deserializationContext.findContextualValueDeserializer(this._arrayType.getContentType(), beanProperty) : deserializationContext.handleSecondaryContextualization(jsonDeserializer, beanProperty);
        TypeDeserializer typeDeserializer = this._elementTypeDeserializer;
        if (typeDeserializer != null) {
            typeDeserializer = typeDeserializer.forProperty(beanProperty);
        }
        return this.withDeserializer(typeDeserializer, jsonDeserializer);
    }

    @Override
    public JavaType getContentType() {
        return this._arrayType.getContentType();
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._elementDeserializer;
    }

    @Override
    public Object[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Object object;
        JsonToken jsonToken;
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext);
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n = 0;
        TypeDeserializer typeDeserializer = this._elementTypeDeserializer;
        while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            object = jsonToken == JsonToken.VALUE_NULL ? this._elementDeserializer.getNullValue() : (typeDeserializer == null ? this._elementDeserializer.deserialize(jsonParser, deserializationContext) : this._elementDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer));
            if (n >= objectArray.length) {
                objectArray = objectBuffer.appendCompletedChunk(objectArray);
                n = 0;
            }
            objectArray[n++] = object;
        }
        object = this._untyped ? objectBuffer.completeAndClearBuffer(objectArray, n) : objectBuffer.completeAndClearBuffer(objectArray, n, this._elementClass);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return object;
    }

    public Object[] deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return (Object[])typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    protected Byte[] deserializeFromBase64(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        byte[] byArray = jsonParser.getBinaryValue(deserializationContext.getBase64Variant());
        Byte[] byteArray = new Byte[byArray.length];
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byteArray[i] = byArray[i];
        }
        return byteArray;
    }

    private final Object[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Object object;
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && (object = jsonParser.getText()).length() == 0) {
            return null;
        }
        if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && this._elementClass == Byte.class) {
                return this.deserializeFromBase64(jsonParser, deserializationContext);
            }
            throw deserializationContext.mappingException(this._arrayType.getRawClass());
        }
        object = jsonParser.getCurrentToken();
        Object object2 = object == JsonToken.VALUE_NULL ? this._elementDeserializer.getNullValue() : (this._elementTypeDeserializer == null ? this._elementDeserializer.deserialize(jsonParser, deserializationContext) : this._elementDeserializer.deserializeWithType(jsonParser, deserializationContext, this._elementTypeDeserializer));
        Object[] objectArray = this._untyped ? new Object[1] : (Object[])Array.newInstance(this._elementClass, 1);
        objectArray[0] = object2;
        return objectArray;
    }
}

