/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.AbstractCloudConnector;
import org.springframework.cloud.CloudException;
import org.springframework.cloud.FallbackServiceInfoCreator;
import org.springframework.cloud.app.ApplicationInstanceInfo;
import org.springframework.cloud.cloudfoundry.ApplicationInstanceInfoCreator;
import org.springframework.cloud.cloudfoundry.CloudFoundryFallbackServiceInfoCreator;
import org.springframework.cloud.cloudfoundry.CloudFoundryServiceInfoCreator;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.cloud.service.BaseServiceInfo;
import org.springframework.cloud.util.EnvironmentAccessor;

public class CloudFoundryConnector
extends AbstractCloudConnector<Map<String, Object>> {
    private ObjectMapper objectMapper = new ObjectMapper();
    private EnvironmentAccessor environment = new EnvironmentAccessor();
    private ApplicationInstanceInfoCreator applicationInstanceInfoCreator = new ApplicationInstanceInfoCreator();

    public CloudFoundryConnector() {
        super(CloudFoundryServiceInfoCreator.class);
    }

    public boolean isInMatchingCloud() {
        return this.environment.getEnvValue("VCAP_APPLICATION") != null;
    }

    public ApplicationInstanceInfo getApplicationInstanceInfo() {
        try {
            Map rawApplicationInstanceInfo = this.objectMapper.readValue(this.environment.getEnvValue("VCAP_APPLICATION"), Map.class);
            return this.applicationInstanceInfoCreator.createApplicationInstanceInfo(rawApplicationInstanceInfo);
        }
        catch (Exception e) {
            throw new CloudException((Throwable)e);
        }
    }

    void setCloudEnvironment(EnvironmentAccessor environment) {
        this.environment = environment;
    }

    protected List<Map<String, Object>> getServicesData() {
        String servicesString = this.environment.getEnvValue("VCAP_SERVICES");
        Map rawServices = new HashMap();
        if (servicesString != null && servicesString.length() > 0) {
            try {
                rawServices = this.objectMapper.readValue(servicesString, Map.class);
            }
            catch (Exception e) {
                throw new CloudException((Throwable)e);
            }
        }
        ArrayList<Map<String, Object>> flatServices = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : rawServices.entrySet()) {
            flatServices.addAll((Collection)entry.getValue());
        }
        return flatServices;
    }

    protected FallbackServiceInfoCreator<BaseServiceInfo, Map<String, Object>> getFallbackServiceInfoCreator() {
        return new CloudFoundryFallbackServiceInfoCreator();
    }
}

