/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

public abstract class SingleImplementationImportSelector<T>
implements DeferredImportSelector,
BeanClassLoaderAware,
EnvironmentAware {
    private static final Log log = LogFactory.getLog(SingleImplementationImportSelector.class);
    private ClassLoader beanClassLoader;
    private Class<T> annotationClass = GenericTypeResolver.resolveTypeArgument(this.getClass(), SingleImplementationImportSelector.class);
    private Environment environment;

    protected SingleImplementationImportSelector() {
    }

    public String[] selectImports(AnnotationMetadata metadata) {
        if (!this.isEnabled()) {
            return new String[0];
        }
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(this.annotationClass.getName(), true));
        Assert.notNull((Object)attributes, (String)("No " + this.getSimpleName() + " attributes found. Is " + metadata.getClassName() + " annotated with @" + this.getSimpleName() + "?"));
        List<Object> factories = new ArrayList(new LinkedHashSet(SpringFactoriesLoader.loadFactoryNames(this.annotationClass, (ClassLoader)this.beanClassLoader)));
        if (factories.isEmpty()) {
            throw new IllegalStateException("Annotation @" + this.getSimpleName() + " found, but there are no implementations.  Did you forget to include a starter?");
        }
        if (factories.size() > 1) {
            String factory = (String)factories.get(0);
            log.warn((Object)("More than one implementation of @" + this.getSimpleName() + ".  Using " + factory + " out of available " + factories));
            factories = Collections.singletonList(factory);
        }
        return factories.toArray(new String[factories.size()]);
    }

    protected abstract boolean isEnabled();

    protected String getSimpleName() {
        return this.annotationClass.getSimpleName();
    }

    protected Class<T> getAnnotationClass() {
        return this.annotationClass;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }
}

