/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery;

import javax.annotation.PreDestroy;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.cloud.client.discovery.DiscoveryLifecycle;
import org.springframework.cloud.client.discovery.ManagementServerPortUtils;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;

public abstract class AbstractDiscoveryLifecycle
implements DiscoveryLifecycle,
ApplicationContextAware {
    private boolean autoStartup = true;
    private boolean running;
    private int order = 0;
    private ApplicationContext context;
    private Environment environment;

    protected ApplicationContext getContext() {
        return this.context;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        this.environment = this.context.getEnvironment();
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        if (!this.isEnabled()) {
            return;
        }
        this.register();
        if (ManagementServerPortUtils.isDifferent((BeanFactory)this.context)) {
            this.registerManagement();
        }
        this.context.publishEvent(new InstanceRegisteredEvent<Object>(this, this.getConfiguration()));
        this.running = true;
    }

    protected abstract Object getConfiguration();

    protected abstract void register();

    protected void registerManagement() {
    }

    protected abstract void deregister();

    protected void deregisterManagement() {
    }

    protected abstract boolean isEnabled();

    protected String getManagementServiceId() {
        return this.context.getId() + ":management";
    }

    protected String getManagementServiceName() {
        return this.getAppName() + ":management";
    }

    protected Integer getManagementPort() {
        return ((ManagementServerProperties)this.context.getBean(ManagementServerProperties.class)).getPort();
    }

    protected String getAppName() {
        return this.environment.getProperty("spring.application.name");
    }

    public void stop() {
        if (this.isEnabled()) {
            this.deregister();
            if (this.getManagementPort() != null) {
                this.deregisterManagement();
            }
        }
        this.running = false;
    }

    @PreDestroy
    public void destroy() {
        this.stop();
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getOrder() {
        return this.order;
    }

    public int getPhase() {
        return 0;
    }
}

