/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.noop;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.noop.NoopDiscoveryClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

@Configuration
@EnableConfigurationProperties
@ConditionalOnMissingBean(value={DiscoveryClient.class})
public class NoopDiscoveryClientAutoConfiguration
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Log log = LogFactory.getLog(NoopDiscoveryClientAutoConfiguration.class);
    @Autowired(required=false)
    private ServerProperties server;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private Environment environment;
    private DefaultServiceInstance serviceInstance;

    @PostConstruct
    public void init() {
        String host = "localhost";
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.error((Object)"Cannot get host info", (Throwable)e);
        }
        int port = this.findPort();
        this.serviceInstance = new DefaultServiceInstance(this.environment.getProperty("spring.application.name", "application"), host, port);
    }

    private int findPort() {
        int port = 0;
        if (this.server != null && this.server.getPort() != null) {
            port = this.server.getPort();
        }
        if (ClassUtils.isPresent((String)"org.springframework.web.context.support.GenericWebApplicationContext", null)) {
            EmbeddedServletContainer container;
            if (this.context instanceof EmbeddedWebApplicationContext && (container = ((EmbeddedWebApplicationContext)this.context).getEmbeddedServletContainer()) != null) {
                port = container.getPort();
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Could not locate port in embedded container (spring-web not available)");
        }
        return port;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.context.publishEvent(new InstanceRegisteredEvent<Environment>(this, this.environment));
    }

    @Bean
    public DiscoveryClient discoveryClient() {
        return new NoopDiscoveryClient(this.serviceInstance);
    }
}

