/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.reactive.DeferringLoadBalancerExchangeFilterFunction;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerExchangeFilterFunction;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerWebClientBuilderBeanPostProcessor;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.client.loadbalancer.reactive.ReactorLoadBalancerClientAutoConfiguration;
import org.springframework.cloud.client.loadbalancer.reactive.ReactorLoadBalancerExchangeFilterFunction;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Primary;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@ConditionalOnClass(value={WebClient.class})
@Conditional(value={OnAnyLoadBalancerImplementationPresentCondition.class})
public class LoadBalancerBeanPostProcessorAutoConfiguration {
    @Bean
    public LoadBalancerWebClientBuilderBeanPostProcessor loadBalancerWebClientBuilderBeanPostProcessor(DeferringLoadBalancerExchangeFilterFunction deferringExchangeFilterFunction, ApplicationContext context) {
        return new LoadBalancerWebClientBuilderBeanPostProcessor(deferringExchangeFilterFunction, context);
    }

    static final class OnAnyLoadBalancerImplementationPresentCondition
    extends AnyNestedCondition {
        private OnAnyLoadBalancerImplementationPresentCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={LoadBalancerClient.class})
        static class LoadBalancerClientPresent {
            LoadBalancerClientPresent() {
            }
        }

        @ConditionalOnBean(value={ReactiveLoadBalancer.Factory.class})
        static class ReactiveLoadBalancerFactoryPresent {
            ReactiveLoadBalancerFactoryPresent() {
            }
        }
    }

    @Configuration
    @ConditionalOnBean(value={LoadBalancerClient.class})
    @AutoConfigureAfter(value={ReactorDeferringLoadBalancerFilterConfig.class})
    @Deprecated
    protected static class ReactiveLoadBalancerConfig {
        protected ReactiveLoadBalancerConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        DeferringLoadBalancerExchangeFilterFunction<LoadBalancerExchangeFilterFunction> deferringLoadBalancerExchangeFilterFunction(ObjectProvider<LoadBalancerExchangeFilterFunction> exchangeFilterFunctionProvider) {
            return new DeferringLoadBalancerExchangeFilterFunction<LoadBalancerExchangeFilterFunction>(exchangeFilterFunctionProvider);
        }
    }

    @Configuration
    @Conditional(value={ReactorLoadBalancerClientAutoConfiguration.OnNoRibbonDefaultCondition.class})
    @ConditionalOnBean(value={ReactiveLoadBalancer.Factory.class})
    protected static class ReactorDeferringLoadBalancerFilterConfig {
        protected ReactorDeferringLoadBalancerFilterConfig() {
        }

        @Bean
        @Primary
        DeferringLoadBalancerExchangeFilterFunction<ReactorLoadBalancerExchangeFilterFunction> reactorDeferringLoadBalancerExchangeFilterFunction(ObjectProvider<ReactorLoadBalancerExchangeFilterFunction> exchangeFilterFunctionProvider) {
            return new DeferringLoadBalancerExchangeFilterFunction<ReactorLoadBalancerExchangeFilterFunction>(exchangeFilterFunctionProvider);
        }
    }
}

