/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.encrypt;

import org.springframework.cloud.config.encrypt.KeyFormatException;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;

public class EncryptorFactory {
    private static final String SALT = "deadbeef";

    public TextEncryptor create(String data) {
        RsaSecretEncryptor encryptor;
        if (data.contains("RSA PRIVATE KEY")) {
            try {
                encryptor = new RsaSecretEncryptor(data);
            }
            catch (IllegalArgumentException e) {
                throw new KeyFormatException();
            }
        } else {
            if (data.startsWith("ssh-rsa") || data.contains("RSA PUBLIC KEY")) {
                throw new KeyFormatException();
            }
            encryptor = Encryptors.text((CharSequence)data, (CharSequence)SALT);
        }
        return encryptor;
    }
}

