/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.config.server.ConfigServerProperties;
import org.springframework.cloud.config.server.EncryptionController;
import org.springframework.cloud.config.server.EnvironmentController;
import org.springframework.cloud.config.server.EnvironmentRepository;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.encrypt.TextEncryptor;

@Configuration
@ConditionalOnWebApplication
public class ConfigServerMvcConfiguration {
    @Autowired(required=false)
    private TextEncryptor encryptor;
    @Autowired
    private EnvironmentRepository repository;
    @Autowired
    private ConfigServerProperties server;

    @Bean
    public EnvironmentController environmentController() {
        EnvironmentController controller = new EnvironmentController(this.repository, this.encryptionController());
        controller.setDefaultLabel(this.server.getDefaultLabel());
        controller.setOverrides(this.server.getOverrides());
        return controller;
    }

    @Bean
    public EncryptionController encryptionController() {
        EncryptionController controller = new EncryptionController();
        if (this.encryptor != null) {
            controller.setEncryptor(this.encryptor);
        }
        return controller;
    }
}

